<?php
// class Role extends SplEnum {
//     const __default = self::Admin;
//     const Admin = 1;
//     const Supervisor = 2;
//     const FittingManager = 3;
//     const Worker = 4;
// }
class controller {
    private $model;
    private $lib;
    public function __construct(model $model, lib $lib)
    {
         $this->model = $model;
         $this->lib = $lib;
    }

    /* #region AUTHENTICATION  */
    public function login($params, $platform='web') {
        $result = array();
        $params = $this->lib->purifyParams($params);
        extract($params, EXTR_SKIP);
        $username = isset($username) ? $username : '';
        $password = isset($password) ? $password : '';
        if($username == '' || $password == '') {
            return $this->lib->prepareError("Missing fields", "Username and password are required");
        }
        //try login
        $user = $this->model->userLogin($username, $password, $platform);
        if(empty($user)) {
            return $this->lib->prepareError("Invalid", "Invalid username or password");
        }
        $isDeleted = $user['deleted'] == 1;
        $isActive = $user['active'] == 1;
        if($isDeleted) {
            return $this->lib->prepareError("Removed", "This account is removed by the admin");
        }
        if(!$isActive) {
            return $this->lib->prepareError("Deactivated", "This account is deactivated by the admin");
        }
        $userData = array(
            'userId'    => $user['userId']
        );
        $token = $this->encodeUserJWT($userData);
        $user['token'] = $token;
        unset($user['password']);
        $result = $user;
        return $result;
    }
    public function forgotPassword($params, $platform='web') {
        $result = $error = array();
        $params = $this->lib->purifyParams($params);
        extract($params, EXTR_SKIP);
        //params validation
        $email = isset($email) ? $email : '';
        if($email == ''){
            return $this->lib->prepareError("Missing fields", "Email is required");
        }
        //try login
        $user = $this->model->findUserByEmail($email);
        if(empty($user)) {
            return $this->lib->prepareError("Not found", "Email not found");
        }
        else {
            $_userId = $user['userId'];
            $forgot_code = $this->model->generateForgotCode();
            $this->model->updateForgotCode($_userId, $forgot_code);
            //send message
            $textsArr = $this->lib->resetPasswordTexts($user['fullname'], $forgot_code);
            $subject = $textsArr['subject'];
            $message = $textsArr['message'];
            $__result = sendMail($email, $subject, $message);
            if ($__result) {
                return true;
            } else {
                return $this->lib->prepareError("Error", "Failed to send mail message");
            }
        }
        return $result;
    }
    // public function resetUserPassword($params, $platform='web') {
    //     $result = array();
    //     $params = $this->lib->purifyParams($params);
    //     extract($params, EXTR_SKIP);
    //     //params validation
    //     $valid = $this->model->getUserById($_userId)['forgot_code'] != '';
    //     if(!$valid) {
    //         return $this->lib->prepareError("Code expired", "Request a new reset password mail");
    //     }
    //     else if($platform == 'mobile') { 
    //         if(!$this->model->authorizeUser($_userId, 'mobile_forgot')) {
    //             return $this->lib->prepareError("Unauthorized", "You don't have permission to reset password");
    //         }
    //     }
    //     $result =$this->model->updateUserPassword($_userId, $password);
    //     $this->model->updateForgotCode($_userId, '');
    //     return $result;
    // }

    private function encodeUserJWT($data) {
        return JWT::encode($data, AUTH_SECRET);
    }
    /* #endregion */

    /* #region CUSTOMERS      */
    public function getAllCustomers($_userId) {
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getAllCustomers();
		}
        return $this->lib->unauthorizedError();
    }
    public function getCustomerById($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getCustomerById($id);
		}
        return $this->lib->unauthorizedError();
    }
    public function createCustomer($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			// $mobile = $this->model->prepareMobileNumber($params['mobile']);
			// if(!$this->model->validateMobileNumber($mobile)) {
			// 	return $this->lib->InvalidMobileError();	
			// }
			// else if(!$this->model->isCustomerMobileAvailable($mobile)) {
			// 	return $this->lib->mobileUnavailableError();
			// }
			$requiredFields = ['customerName', 'SAP'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			if(!$this->model->isCustomerSAPAvailable($SAP)) {
				return $this->lib->SAPUnavailableError();
			}
			//execute
			return $this->model->createCustomer($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function updateCustomer($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			// $customerId = $params['customerId'];
			// $mobile = $this->model->prepareMobileNumber($params['mobile']);
			// if(!$this->model->validateMobileNumber($mobile)) {
			// 	return $this->lib->InvalidMobileError();	
			// }
			// else if(!$this->model->isCustomerMobileAvailable($mobile, $customerId)) {
			// 	return $this->lib->mobileUnavailableError();	
			// }
			$requiredFields = ['customerId', 'customerName', 'SAP'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			if(!$this->model->isCustomerSAPAvailable($SAP)) {
				return $this->lib->SAPUnavailableError();
			}
			//execute
			return $this->model->updateCustomer($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function deleteCustomer($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$id = $params['customerId'];
			return $this->model->deleteCustomer($id);
		}
        return $this->lib->unauthorizedError();
    }
    /* #endregion */

    /* #region CENTERS */
    public function getAllCenters($_userId) {
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getAllCenters();
		}
        return $this->lib->unauthorizedError();
    }
    public function getCenterById($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getCenterById($id);
		}
        return $this->lib->unauthorizedError();
    }
    public function createCenter($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['centerName'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->createCenter($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function updateCenter($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['centerId', 'centerName'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->updateCenter($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function deleteCenter($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$id = $params['centerId'];
			return $this->model->deleteCenter($id);
		}
        return $this->lib->unauthorizedError();
    }
	/* #endregion */
	
    /* #region STATIONS */
    public function getAllStations($_userId) {
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getAllStations();
		}
        return $this->lib->unauthorizedError();
    }
    public function getStationById($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getStationById($id);
		}
        return $this->lib->unauthorizedError();
    }
    public function createStation($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['centerId', 'stationName'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->createStation($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function updateStation($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = [ 'stationId', 'centerId', 'stationName'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->updateStation($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function deleteStation($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$id = $params['stationId'];
			return $this->model->deleteStation($id);
		}
        return $this->lib->unauthorizedError();
    }
	/* #endregion */
	
    /* #region PROJECTS */
    public function getAllProjects($_userId) {
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getAllProjects();
		}
        return $this->lib->unauthorizedError();
    }
    public function getProjectById($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getProjectById($id);
		}
        return $this->lib->unauthorizedError();
    }
    public function createProject($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['customerId', 'projectName'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->createProject($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function updateProject($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = [ 'projectId', 'customerId', 'projectName'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->updateProject($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function deleteProject($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$id = $params['projectId'];
			return $this->model->deleteProject($id);
		}
        return $this->lib->unauthorizedError();
    }
	/* #endregion */
	
    /* #region RAW MATERIALS */
    public function getAllMaterials($_userId) {
		if($this->model->isUserInGroup($_userId, array(Admin, Team))) {
			return $this->model->getAllMaterials();
		}
        return $this->lib->unauthorizedError();
    }
    public function getMaterialById($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getMaterialById($id);
		}
        return $this->lib->unauthorizedError();
    }
    public function createMaterial($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['materialName', 'materialType', 'unit'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->createMaterial($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function updateMaterial($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['materialId', 'materialName', 'materialType', 'unit'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->updateMaterial($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function deleteMaterial($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$id = $params['materialId'];
			return $this->model->deleteMaterial($id);
		}
        return $this->lib->unauthorizedError();
    }
	/* #endregion */
	
    /* #region WORKERS */
    public function getAllWorkers($_userId) {
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getAllWorkers();
		}
        return $this->lib->unauthorizedError();
    }
    public function getWorkerById($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getWorkerById($id);
		}
        return $this->lib->unauthorizedError();
    }
    public function createWorker($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['workerName', 'amiantitId'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			$params['userId'] = isset($params['userId']) ? $params['userId'] : 0;
			if(!$this->model->isWorkerAmiantitIdAvailable($amiantitId)) {
				return $this->lib->amiantitIdUnavailableError();
			}
			//execute
			return $this->model->createWorkerTransaction($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function updateWorker($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['workerId', 'workerName', 'amiantitId'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			$worker = $this->model->getWorkerById($workerId);
			$params['userId'] = isset($params['userId']) ? $params['userId'] : 0;
			if(!$this->model->isWorkerAmiantitIdAvailable($amiantitId, $worker['amiantitId'])) {
				return $this->lib->amiantitIdUnavailableError();
			}
			//execute
			return $this->model->updateWorkerTransaction($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function deleteWorker($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$id = $params['workerId'];
			return $this->model->deleteWorker($id);
		}
        return $this->lib->unauthorizedError();
    }
	/* #endregion */
	
    /* #region PROCESSES */
    public function getAllProcesses($_userId) {
		if($this->model->isUserInGroup($_userId, array(Admin, Team))) {
			return $this->model->getAllProcesses();
		}
        return $this->lib->unauthorizedError();
    }
    public function getProcessById($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getProcessById($id);
		}
        return $this->lib->unauthorizedError();
    }
    public function createProcess($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['processName'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->createProcess($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function updateProcess($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['processId', 'processName'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->updateProcess($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function deleteProcess($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$id = $params['processId'];
			return $this->model->deleteProcess($id);
		}
        return $this->lib->unauthorizedError();
    }
	/* #endregion */
	
    /* #region TEAMS */
    public function getAllTeams($_userId) {
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getAllTeams();
		}
        return $this->lib->unauthorizedError();
    }
    public function getAllVisibleTeams($_userId) {
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getAllVisibleTeams();
		}
        return $this->lib->unauthorizedError();
    }
    public function getTeamWorkers($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getTeamWorkers($id);
		}
        return $this->lib->unauthorizedError();
    }
    public function getTeamById($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$result = $this->model->getTeamById($id);
			$workers = $this->model->getTeamWorkers($id);
			$result['workersIds'] = array_column($workers, 'workerId');
			$result['workers'] = $workers;
			return $result;
		}
        return $this->lib->unauthorizedError();
    }
    public function createTeam($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['fullname', 'username', 'password'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			if(!$this->model->usernameAvailable($username)) {
				return $this->lib->usernameUnavailableError();
			}
			//execute
			return $this->model->createTeamTransaction($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function updateTeam($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['userId', 'fullname', 'username'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			if(!$this->model->usernameAvailable($username, $userId)) {
				return $this->lib->usernameUnavailableError();
			}
			//execute
			return $this->model->updateTeamTransaction($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function deleteTeam($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$id = $params['userId'];
			return $this->model->deleteTeam($id);
		}
        return $this->lib->unauthorizedError();
    }
    /* #endregion */

    /* #region USERS */
    public function getAllUsers($_userId) {
		if($this->model->isUserInGroup($_userId, array(TopAdmin))) {
			return $this->model->getAllUsers();
		}
		else if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getUsersForAdmin();
		}
        return $this->lib->unauthorizedError();
    }
    public function getUserGroups($_userId) {
		if($this->model->isUserInGroup($_userId, array(TopAdmin))) {
			return $this->model->getAllUserGroups();
		}
		else if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getUserGroupsForAdmin();
		}
        return $this->lib->unauthorizedError();
    }
    public function getUserById($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$result = $this->model->getUserById($id);
			return $result;
		}
        return $this->lib->unauthorizedError();
    }
    public function createUser($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['groupId', 'fullname', 'username', 'mobile', 'password', 'amiantitId'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			$mobile = $this->model->prepareMobileNumber($params['mobile']);
			if(!$this->model->validateMobileNumber($mobile)) {
				return $this->lib->InvalidMobileError();	
			}
			else if(!$this->model->isUserMobileAvailable($mobile)) {
				return $this->lib->mobileUnavailableError();
			}
			else if(!$this->model->usernameAvailable($username)) {
				return $this->lib->usernameUnavailableError();
			}
			else if(!$this->model->isUserAmiantitIdAvailable($amiantitId)) {
				return $this->lib->amiantitIdUnavailableError();
			}
			//execute
			return $this->model->createUserTransaction($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function updateUser($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(TopAdmin))) {
			//params validation
			$requiredFields = ['userId', 'groupId', 'fullname', 'username', 'mobile', 'amiantitId'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			$user = $this->model->getUserById($userId);
			$mobile = $this->model->prepareMobileNumber($params['mobile']);
			if(!$this->model->validateMobileNumber($mobile)) {
				return $this->lib->InvalidMobileError();	
			}
			else if(!$this->model->isUserMobileAvailable($mobile, $userId)) {
				return $this->lib->mobileUnavailableError();
			}
			else if(!$this->model->usernameAvailable($username, $userId)) {
				return $this->lib->usernameUnavailableError();
			}
			else if(!$this->model->isUserAmiantitIdAvailable($amiantitId, $user['amiantitId'])) {
				return $this->lib->amiantitIdUnavailableError();
			}
			else if($userId == 1 && $_userId != 1) {
				return $this->lib->prepareError("Unauthorized", "You cannot edit the main top admin");
			}
			//execute
			return $this->model->updateUserTransaction($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function deleteUser($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroupStrict($_userId, array(TopAdmin, Admin))) {
			$id = $params['userId'];
			if($id == 1) {
				return $this->lib->prepareError("Unauthorized", "The main top admin cannot be deleted");		
			}
			//if user of api is Admin only allow him to remove non admin users
			if($this->model->isUserInGroupStrict($_userId, array(Admin))) {
				if($this->model->isUserInGroupStrict($id, array(TopAdmin))) {
					return $this->lib->prepareError("Unauthorized", "You cannot delete admin employees");		
				}
			}
			return $this->model->deleteUser($id);
		}
        return $this->lib->unauthorizedError();
    }
    /* #endregion */

    /* #region ORDERS */
    public function getAllOrders($_userId) {
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getAllOrders();
		}
        return $this->lib->unauthorizedError();
    }
    public function getOrderById($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$result = $this->model->getOrderById($id);
			return $result;
		}
        return $this->lib->unauthorizedError();
    }
    public function createOrder($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['projectId', 'orderNo'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->createOrder($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function updateOrder($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['orderId', 'projectId', 'orderNo'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->updateOrder($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function deleteOrder($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$id = $params['orderId'];
			return $this->model->deleteOrderTransaction($id);
		}
        return $this->lib->unauthorizedError();
    }
	/* #endregion */
	
    /* #region SPOOL LINES */
    public function getAllLines($_userId) {
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getAllLines();
		}
        return $this->lib->unauthorizedError();
    }
    public function getLineById($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$result = $this->model->getLineById($id);
			$result['materials'] = $this->model->getLineMaterials($id);
			return $result;
		}
        return $this->lib->unauthorizedError();
    }
    public function createLine($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['orderId', 'lineNo', 'spoolNo', 'spoolTypeId', 'spoolDN', 'spoolQuantity'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			if(!is_numeric($spoolDN)) {
				return $this->lib->InvalidNumberError("SpoolDN");
			}
			if(!is_numeric($spoolQuantity)) {
				return $this->lib->InvalidNumberError("Spool Quantity");
			}
			if(isset($pricePerPiece) && !is_numeric($pricePerPiece)) {
				return $this->lib->InvalidNumberError("Price per piece");
			}
			if(isset($plannedHoursPerPiece) && !is_numeric($plannedHoursPerPiece)) {
				return $this->lib->InvalidNumberError("Planned hours per piece");
			}
			if(count($materials)>0) {
				if(!$this->lib->validateNumericAllMaterials($materials)) {
					return $this->lib->materialsError();
				}
			}
			//execute
			return $this->model->createLineTransaction($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function updateLine($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['lineId', 'orderId', 'lineNo', 'spoolNo', 'spoolTypeId', 'spoolDN'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			if(!is_numeric($spoolDN)) {
				return $this->lib->InvalidNumberError("SpoolDN");
			}
			if(!is_numeric($spoolQuantity)) {
				return $this->lib->InvalidNumberError("Spool Quantity");
			}
			if(isset($pricePerPiece) && !is_numeric($pricePerPiece)) {
				return $this->lib->InvalidNumberError("Price per piece");
			}
			if(isset($plannedHoursPerPiece) && !is_numeric($plannedHoursPerPiece)) {
				return $this->lib->InvalidNumberError("Planned hours per piece");
			}
			if(count($materials)>0) {
				if(!$this->lib->validateNumericAllMaterials($materials)) {
					return $this->lib->materialsError();
				}
			}
			//execute
			return $this->model->updateLineTransaction($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function deleteLine($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$id = $params['lineId'];
			return $this->model->deleteLineTransaction($id);
		}
        return $this->lib->unauthorizedError();
    }
	/* #endregion */
	
    /* #region SPOOL LINES */
    public function getAllSpools($_userId) {
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getAllSpools();
		}
        return $this->lib->unauthorizedError();
    }
    public function getSpoolById($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$result = $this->model->getSpoolById($id);
			$result['stages'] = $this->model->getSpoolStagesById($id);
			return $result;
		}
        return $this->lib->unauthorizedError();
    }
    public function getSpoolByUUID($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isTeamEmpty($_userId)) {
			return $this->lib->emptyTeamError();
		}
		if($this->model->isUserInGroup($_userId, array(Admin, Supervisor, Team))) {
			$result = $this->model->getSpoolByUUID($uuid);
			if(!empty($result)) {
				$id = $result['spoolId'];
				$result['stages'] = $this->model->getSpoolStagesById($id);
				$result['lastStage'] = $this->model->getSpoolLastStageById($id);
				$result['canScanIn'] = $this->model->canSpoolScanIn($id);
				$result['canScanOut'] = $this->model->canSpoolScanOut($id);
			}
			return $result;
		}
        return $this->lib->unauthorizedError();
    }
    public function getSpoolLastStageById($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getSpoolLastStageById($id);
		}
        return $this->lib->unauthorizedError();
    }
    // public function createSpool($params, $_userId) {
	// 	$params = $this->lib->purifyParams($params);
	// 	extract($params, EXTR_SKIP);
	// 	if($this->model->isUserInGroup($_userId, array(Admin))) {
	// 		//params validation
	// 		$requiredFields = ['lineId', 'serial', 'scheduledDeliveryDate', 'productionOrder'];
	// 		$validationError = $this->validateRequiredFields($requiredFields, $params);
	// 		if($validationError){return $validationError;}
	// 		$uuid = $this->lib->generateUUID();
	// 		$params['uuid'] = $uuid;
	// 		//execute
	// 		return $this->model->createSpool($params);
	// 	}
    //     return $this->lib->unauthorizedError();
    // }
    public function updateSpool($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['spoolId', 'status', 'scheduledDeliveryDate', 'productionOrder'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->updateSpool($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function updateSpoolStatus($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['spoolId', 'status'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			$spoolStatus = $this->model->getSpoolStatusById($spoolId);
			if($spoolStatus == 'Finished') {
				$status = 'Released';
			}
			return $this->model->updateSpoolStatus($spoolId, $status);
		}
        return $this->lib->unauthorizedError();
    }
    public function deleteSpool($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$id = $params['spoolId'];
			return $this->model->deleteSpool($id);
		}
        return $this->lib->unauthorizedError();
    }
    /* #endregion */

    /* #region SPOOLTYPES */
	public function getAllSpooltypes($_userId){
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			return $this->model->getAllSpoolTypes();
		}
        return $this->lib->unauthorizedError();
	}
	//CREATE & UPDATE
	public function createSpoolType($params, $_userId){
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['spoolTypeName'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->createSpoolType($params);
		}
        return $this->lib->unauthorizedError();
	}
	public function updateSpoolType($params, $_userId){
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['spoolTypeId', 'spoolTypeName'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->updateSpoolType($params);
		}
        return $this->lib->unauthorizedError();
	}
    public function deleteSpoolType($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$id = $params['spoolTypeId'];
			return $this->model->deleteSpoolType($id);
		}
        return $this->lib->unauthorizedError();
    }
	/* #endregion */
	
    /* #region SPOOLTYPES */
	public function getAllLocations($_userId){
		if($this->model->isUserInGroup($_userId, array(Admin, Team))) {
			return $this->model->getAllLocations();
		}
        return $this->lib->unauthorizedError();
	}
	//CREATE & UPDATE
	public function createLocation($params, $_userId){
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['locationName'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->createLocation($params);
		}
        return $this->lib->unauthorizedError();
	}
	public function updateLocation($params, $_userId){
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			//params validation
			$requiredFields = ['locationId', 'locationName'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			//execute
			return $this->model->updateLocation($params);
		}
        return $this->lib->unauthorizedError();
	}
    public function deleteLocation($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin))) {
			$id = $params['locationId'];
			return $this->model->deleteLocation($id);
		}
        return $this->lib->unauthorizedError();
    }
	/* #endregion */
	
    /* #region SPOOL STAGES */
	public function createSpoolStage($params, $_userId){
		$params = $this->lib->purifyParams($params);
		$params['userId'] = $_userId;
		extract($params, EXTR_SKIP);
		$materials = isset($materials) ? $materials : array();
		$comment = isset($comment) ? $comment : null;
		if($stageTypeId != Rejected) {$params['comment'] = null;} //comment only needed when rejecting
		if($this->model->isUserInGroup($_userId, array(Admin, Supervisor, Team))) {
			//params validation
			$requiredFields = ['spoolId', 'processId', 'stageTypeId', 'locationId'];
			$validationError = $this->validateRequiredFields($requiredFields, $params);
			if($validationError){return $validationError;}
			if($this->model->isTeamEmpty($_userId)) {
				return $this->lib->emptyTeamError();
			}
			// if($this->model->getSpoolStatusById($spoolId) == 'Finished') {
			// 	return $this->lib->prepareError("Error", "Please scan an unfinished spool");
			// }
			if($stageTypeId == ScanIn) {
				if(!$this->model->canSpoolScanIn($spoolId)) {
					return $this->lib->prepareError("Invalid order", "You cannot scan in a spool twice in a row");
				}
			}
			else if($stageTypeId == ScanOut) {
				if(!$this->model->canSpoolScanOut($spoolId)) {
					return $this->lib->prepareError("Invalid order", "Wait for spool to be Scanned In first");
				}
				if(count($materials)>0) {
					if(!$this->lib->validateNumericAllMaterials($materials)) {
						return $this->lib->materialsError();
					}
				}
				// else if(count($materials) <=0) { //Scanning out a spool requires materails to be added
				// 	return $this->lib->prepareError("Missing Fields", "At least one raw-material is required");
				// }
			}
			else if($stageTypeId == Rejected) {
				if($comment == null) { //Rejecting a spool requires a comment to be added
					return $this->lib->prepareError("Missing Fields", "Comment is required");
				}
			}
			else if($stageTypeId == Accepted || $stageTypeId == Rejected) {
				if(!$this->model->canSpoolBeQualityChecked($spoolId)) {
					return $this->lib->prepareError("Invalid order", "Wait for spool to be Scanned Out first");
				}
			}
			//execute
			return $this->model->createSpoolStageTransaction($params);
		}
        return $this->lib->unauthorizedError();
	}
	/* #endregion */

    /* #region REPORTS */
    public function dailyReport($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(TopAdmin))) {
			return $this->model->dailyReport($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function fabricationsReport($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(TopAdmin))) {
			return $this->model->fabricationsReport($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function forecastingReport($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(TopAdmin))) {
			return $this->model->forecastingReport($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function teamPerformanceReport($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(TopAdmin))) {
			$params['periodDays'] = 0;
			if(isset($startDate) && isset($endDate)) {
				$params['periodDays'] = $this->lib->diffInDays($startDate, $endDate);
			}
			return $this->model->teamPerformanceReport($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function rawMaterialsEfficiencyReport($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(TopAdmin))) {
			return $this->model->rawMaterialsEfficiencyReport($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function activityReport($params, $_userId) {
		$params = $this->lib->purifyParams($params);
		extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(TopAdmin))) {
			return $this->model->activityReport($params);
		}
        return $this->lib->unauthorizedError();
    }
    public function checkOrders($_userId) {
		// $params = $this->lib->purifyParams($params);
		// extract($params, EXTR_SKIP);
		if($this->model->isUserInGroup($_userId, array(Admin, TopAdmin))) {
			return $this->model->checkOrders();
		}
        return $this->lib->unauthorizedError();
    }
	/* #endregion */

    /* #region VALIDATION */
    public function validateRequiredFields($requiredFields, $params) {
        foreach($requiredFields as $r) {
            if(!isset($params[$r]) ) {
                $message =  $this->lib->getFieldName($r) . ' is required';
                return $this->lib->prepareError("Missing fields", $message);
			}
			else {
				if($params[$r] !== 0 && $params[$r] !== "0" && $params[$r] === null) {
					$message =  $this->lib->getFieldName($r) . ' is required';
					return $this->lib->prepareError("Missing fields", $message);
				}
			}
        }
        return false;
    }
	/* #endregion */
	
    /* #region EXTRAS */
    /* #endregion */

}