<?php
require_once __SYSTEM_DIR__ . '/php/custom/htmlpurifier/HTMLPurifier.auto.php';
require_once __API_ROOT__ . "vendor/autoload.php";
use Endroid\QrCode\QrCode;
use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;
use Box\Spout\Writer\Common\Creator\Style\StyleBuilder;
// use Box\Spout\Common\Entity\Style\CellAlignment;
use Box\Spout\Common\Entity\Style\Color;
class lib
{
	private $p;
	public function __construct()
	{
		$config = HTMLPurifier_Config::createDefault();
		$this->p = new HTMLPurifier($config);
	}
	public function generateQrCodeFile($uuid) {
		$qrCode = new QrCode($uuid);
		$qrCode->setSize(__QRCODE_SIZE__);
		$qrCode->setMargin(__QRCODE_MARGIN__);
		$qrCode->setEncoding('UTF-8');
		$folder = __QRCODES_ROOT__. $uuid;
		$file = $folder ."/1.png";
		try {
			mkdir($folder);
			chmod($folder, 0644); //read for public & read/write for owner
		}
		catch(Exception $e) {
			return false;
		}
		try {
			$qrCode->writeFile($file);
			chmod($file, 0644);
		}
		catch(Exception $e) {
			return false;
		}
		return true;
	}
	public function tablesToExcelFile($data) {
		$writer = WriterEntityFactory::createXLSXWriter();
		$randomName = $this->generateRandomString();
		$fileName = __EXCEL_ROOT__ . $randomName . '.xlsx';
		$writer->openToFile($fileName); // write data to a file or to a PHP stream
		//$writer->openToBrowser('allTables.xlsx');
		//$writer->openToBrowser($fileName); // stream data directly to the browser
		$sheet = $writer->getCurrentSheet();
		$boldStyle = (new StyleBuilder())->setFontBold()->build();
		$isFirst = true;
		foreach($data as $tableName=>$rows) {
			if(!$isFirst) {
				$sheet = $writer->addNewSheetAndMakeItCurrent();
			}
			$sheet->setName($tableName);
			$isFirst = false;
			if(!empty($rows)) {
				$headersValues = array_keys($rows[0]);
				$rowFromheaderValues = WriterEntityFactory::createRowFromArray($headersValues, $boldStyle);
				$writer->addRow($rowFromheaderValues, $boldStyle);
				foreach($rows as $row) {
					$rowValues = array_values($row);
					$rowFromValues = WriterEntityFactory::createRowFromArray($rowValues);
					$writer->addRow($rowFromValues);
				}
			}
		}

		$writer->close();
		return $fileName;
	}
	public function generateDatabase() {
		$writer = WriterEntityFactory::createXLSXWriter();

		// $writer = WriterEntityFactory::createODSWriter();
		// $writer = WriterEntityFactory::createCSVWriter();
		$writer->openToFile('/okboomer.xlsx'); // write data to a file or to a PHP stream
		//$writer->openToBrowser($fileName); // stream data directly to the browser
		$sheet = $this->writer->getCurrentSheet();
		// $sheet = $writer->addNewSheetAndMakeItCurrent();
		// $sheet->setName('kapaa');
		$cells = [
			WriterEntityFactory::createCell('Carl'),
			WriterEntityFactory::createCell('is'),
			WriterEntityFactory::createCell('great!'),
		];
		
		/** add a row at a time for indexes */
		$singleRow = WriterEntityFactory::createRow($cells);
		$writer->addRow($singleRow);
		
		/** add multiple rows at a time for data */
		$multipleRows = [
			WriterEntityFactory::createRow($cells),
			WriterEntityFactory::createRow($cells),
		];
		$writer->addRows($multipleRows); 

		//addNewSheetAndMakeItCurrent
		
		$writer->close();
	}
	public function diffInDays($date1, $date2) {
		$days = 0;
		$datetimeObj1 = new DateTime($date1);
		$datetimeObj2 = new DateTime($date2);
		$interval = $datetimeObj1->diff($datetimeObj2);
		if($interval->format('%a') > 0){
			$days = $interval->format('%a');
		}
		return $days;
	}
	public function base64ToFile($data, $dir = "uploads/checklists/")
	{
		list($type, $data) = explode(';', $data);
		list(, $data)      = explode(',', $data);
		$data = base64_decode($data);
		$newFileName = substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 12);	//	Generate Random
		file_put_contents(__SYSTEM_DIR__ . $dir . $newFileName . ".jpg", $data);
		return $newFileName . ".jpg";
	}
	public function prepareError($title, $message, $show = true)
	{
		$error['title'] = $title;
		$error['message'] = $message;
		$error['show'] = $show;
		return array('error' => $error);
	}
	public function InvalidNumberError($field)
	{
		return $this->prepareError('Invalid', "${field} must be a valid number", true);
	}
	public function InvalidMobileError()
	{
		return $this->prepareError('Invalid', "Mobile number is invalid", true);
	}
	public function amiantitIdUnavailableError()
	{
		return $this->prepareError('Unavailable', "AmiantitId already registered", true);
	}
	public function usernameUnavailableError()
	{
		return $this->prepareError('Unavailable', "Username already registered", true);
	}
	public function mobileUnavailableError()
	{
		return $this->prepareError('Unavailable', "Mobile number already registered", true);
	}
	public function SAPUnavailableError()
	{
		return $this->prepareError('Unavailable', "SAP number already registered", true);
	}
	public function unauthorizedError()
	{
		return $this->prepareError('Unauthorized', "You don't have permissions to do this action.", true);
	}
	public function emptyTeamError()
	{
		return $this->prepareError('Denied', "This team user have no workers assigned to him.", true);
	}
	public function materialsError()
	{
		return $this->prepareError('Invalid', "One or more quantity input is/are not a valid number", true);
	}
	public function validateNumericAllMaterials($materials) 
	{
		foreach($materials as $m) {
			if(!is_numeric($m['quantity'])) {
				return false;
			}
		}
		return true;
	}
	public function purifyParams($arr)
	{
		$result = array();
		$len = count($arr);
		foreach ($arr as $key => $value) {
			if (is_array($value)) {
				$result[$key] = $this->purifyArray($value);
			} else {
				$result[$key] = $this->purify($value);
			}
		}
		return $result;
	}
	public function purifyArray($arr)
	{
		$len = count($arr);
		if ($len <= 0) {
			return array();
		} else {
			for ($i = 0; $i < $len - 1; $i++) {
				$ele = isset($arr[$i]) ? $arr[$i] : null;
				if ($ele == null) {
					continue;
				}
				$p = $this->purify($arr[$i]);
				if (empty($p)) {
					return array();
				}
				$arr[$i] = $p;
			}
		}
		return $arr;
	}

	public function purify($string)
	{
		if (is_string($string)) {
			return $this->p->purify($string);
		}
		return $string;
	}

	public function generateRandomString($maxchars = 12)
	{
		return substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, $maxchars);
	}

	public function upload($file, $extension, $folder = "uploads/layouts/")
	{
		$target_dir = __SYSTEM_DIR__ . $folder;
		$encrypted = $this->generateRandomString(12);
		$target_file = $target_dir . $encrypted . "." . $extension;
		if (file_exists($target_file)) {
			$encrypted = $this->generateRandomString(13);
		}
		move_uploaded_file($file, $target_file);
		$result = $encrypted . "." . $extension;
		return $result;
	}

	function pre($arr)
	{
		echo '<pre>';
		print_r($arr);
		echo '</pre>';
	}
	public function deleteFile($file)
	{
		try {
			if (file_exists($file)) {
				unlink($file);
			}
		} catch (Exception $e) { }
	}
	public function getPDFExtensionFromMime($mime)
	{
		$extensions = array('application/pdf' => 'pdf');
		return $extensions[$mime];
	}
	public function getImageExtensionFromMime($mime)
	{
		$extensions = array(
			'image/jpeg' => 'jpg',
			'image/png' => 'png',
			'image/gif' => 'gif'
		);
		return $extensions[$mime];
	}
	public function validate_reCAPTCHA($secret)
	{
		$post_data = http_build_query(
			array(
				'secret' => $secret,
				'response' => $_POST['g-recaptcha-response'],
				'remoteip' => $_SERVER['REMOTE_ADDR']
			)
		);
		$opts = array(
			'http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/x-www-form-urlencoded',
				'content' => $post_data
			)
		);
		$context  = stream_context_create($opts);
		$response = file_get_contents('https://www.google.com/recaptcha/api/siteverify', false, $context);
		$result = json_decode($response);
		return $result->success;
	}
	public function resetPasswordTexts($name, $forgotCode)
	{
		$subject = 'Password Reset';
		$link = __SYSTEM_ROOT__ . "app/reset/$forgotCode";
		$message = "Hi, $name <br/>
                    Ignore this email if you haven't requested password reset. <br/>
                    To change your password click on this link:<br/>
                    <a href='$link'>$link</a>";
		return array(
			"subject" => $subject,
			"message" => $message
		);
	}
	public function group_by($array, $key) {
		$return = array();
		foreach($array as $val) {
			$return[$val[$key]][] = $val;
		}
		return (array)$return;
	}
	public function getFieldName($field)
	{
		if (isset($this->fieldNames[$field])) {
			return $this->fieldNames[$field];
		}
		return $field;
	}
	private $fieldNames = array(
		'amiantitId'     =>     'Amiantit ID',
		'spoolTypeId'    =>     'Spool Type',
		'materialId'     =>     'Material',
		'processId'      =>     'Process',
		'centerId'       =>     'Center',
		'customerId'     =>     'Customer',
		'userId'         =>     'User',
		'groupId'   	 =>     'User group',
		'orderId'        =>     'Order',
		'locationId'     =>     'Location',
		'quantity'       =>     'Quantity',
		'fullname'       =>     'Fullname',
		'username'       =>     'Username',
		'password'       =>     'Password',
		'comment'        =>     'Comment',
		'address'        =>     'Address',
		'title'          =>     'Title',
		'unit'      	 =>     'Unit',
		'projectName'    =>     'Project name',
		'materialName'   =>     'Material name',
		'groupName'   	 =>     'Group name',
		'processName'    =>     'Process name',
		'teamName'    	 =>     'Team name',
		'image'          =>     'Image',
		'email'     	 =>     'Email',
		'mobile'         =>     'Mobile',
		'email'          =>     'Email',
		'stationName'    =>     'Station name',
		'centerName'     =>     'Center Name',
		'workers'		 =>		'Workers',
	);
}
