<?php
require_once __API_ROOT__ . "vendor/autoload.php";
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\Exception\UnsatisfiedDependencyException;
class model {
	//Visual studio code is awesome and this extension too
	//https://marketplace.visualstudio.com/items?itemName=maptz.regionfolder

	/* #region  BLABLABLA */
	private $err = false;
	public $dbo;
	private $dateFormat='%Y-%m-%d %h:%i %p';
    private $qrcodeBase = __QRCODES_LINK__;
	public function __construct($dbObj) {
		if (isset($dbObj) && is_a($dbObj, 'db')) {
			$this->dbo = $dbObj;
		} else {
			$this->err = true;
		}
		$this->validate_class_usage();
	}
	private function validate_class_usage() {
		if ($this->err) {
			echo "The model class expecting DB Class";
			die();
		}
	}
	/* #endregion */

	/* #region  AUTHENTICATION */
	//----------------------------------------------------------------
	//
	//						AUTHENTICATION
	//
	//----------------------------------------------------------------
	public function validateMobileUser($username) {
        $this->dbo->bind("username","$username");
        $sql = "SELECT u.* FROM users as u
				INNER JOIN user_groups as g
				ON u.groupId = g.groupId
				WHERE LOWER(u.username)=LOWER(:username)
				AND g.name IN ('top_admin', 'admin', 'supervisor', 'team')";
        return $this->dbo->row($sql);
	}
	public function validateWebUser($username) {
        $this->dbo->bind("username","$username");
        $sql = "SELECT u.* FROM users as u
				INNER JOIN user_groups as g
				ON u.groupId = g.groupId
				WHERE LOWER(u.username)=LOWER(:username)
				AND g.name IN ('top_admin', 'admin', 'supervisor')";
        return $this->dbo->row($sql);
	}
	public function userLogin($username, $password, $platform) {
		if($platform == 'web') {
			$result = $this->validateWebUser($username);
		}
		else if($platform == 'mobile') {
			$result = $this->validateMobileUser($username);
		}
        if ($result) {
            if(password_verify($password, $result['password'])) {
                return $result;
            }
		}
		return false;
	}
	//0550858742
	public function validateMobileNumber($mobile) {
		$pattern = '/^0?5[0-9]{8}$/';
		return preg_match($pattern, $mobile) == 1;
	}
	public function prepareMobileNumber($mobile) {
		if($this->validateMobileNumber($mobile)) {
			$len = strlen($mobile);
			if($len == 8) {
				$mobile = '0' . $mobile;
			}
		}
		return $mobile;
    }
	public function newPrepareMobile($mobile, $areacode) {
		if (substr($mobile, 0, 1) === '0') {
			$mobile = ltrim($mobile, '0');
		}
		return $areacode . $mobile;
    }
	public function isUserExistAndActive($userId){
        $this->dbo->bind("userId","$userId");
		$sql = "SELECT * FROM users WHERE deleted=0 AND active=1 AND userId=:userId";
		return !empty($this->dbo->row($sql));
    }

	//user reset password
    public function findUserByEmail($email) {
        $this->dbo->bind("email","$email");
        $sql = "SELECT * FROM users WHERE email=:email AND deleted=0 AND active=1";
        return $this->dbo->row($sql);
    }
	public function generateForgotCode() {
		while(true) {
			$result = substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 45);
			if($this->forgotCodeIsAvailable($result)) {
				return $result;
			}
		}
    }
	public function forgotCodeIsAvailable($code) {
		$bindArray = array(
            "forgot_code"=>"$code"
		);
		$this->dbo->bindMore($bindArray);
		$sql = "SELECT userId from users WHERE forgot_code=:forgot_code";
		return empty($this->dbo->row($sql));
	}
    public function findUserByForgotCode($forgot_code) {
        $this->dbo->bind("forgot_code","$forgot_code");
        $sql = "SELECT * from users WHERE forgot_code=:forgot_code AND forgot_code != '' AND forgot_code is NOT NULL AND deleted=0 AND active=1";
        return $this->dbo->row($sql);
    }
    public function updateUserPassword($userId, $password) {
        $password = password_hash($password, PASSWORD_DEFAULT);
        $this->dbo->bindMore(array(
            "userId" => "$userId",
            "password" => "$password"
        ));
        $sql = "UPDATE users SET `password`=:password WHERE userId=:userId";
        return $this->dbo->query($sql);
    }
    public function updateForgotCode($userId, $forgot_code) {
        $this->dbo->bindMore(array(
            "userId" => "$userId",
            "forgot_code" => "$forgot_code"
        ));
        $sql = "UPDATE users SET forgot_code=:forgot_code WHERE userId=:userId";
        return $this->dbo->query($sql);
	}
	/* #endregion */
	
	/* #region	USERS  */
	//----------------------------------------------------------------
	//
	//						USERS
	//
	//----------------------------------------------------------------
	//VIEW
	public function getAllUsers(){
		$sql = "SELECT u.*, ug.title as `role`, DATE_FORMAT(u.created_at, '$this->dateFormat') as `created_at`
				FROM `users` as u
				INNER JOIN `user_groups` as ug
				ON u.groupId = ug.groupId
				WHERE u.`deleted`=0
				AND u.userType = 'user'
				ORDER BY u.userId ASC";
		return $this->dbo->query($sql);
	}
	public function getUsersForAdmin(){
		$sql = "SELECT u.*, ug.title as `role`, DATE_FORMAT(u.created_at, '$this->dateFormat') as `created_at`
				FROM `users` as u
				INNER JOIN `user_groups` as ug
				ON u.groupId = ug.groupId
				WHERE u.`deleted`=0
				AND u.userType = 'user'
				AND u.groupId NOT IN (1)
				ORDER BY u.userId ASC";
		return $this->dbo->query($sql);
	}
	public function getAllUserGroups(){
		$sql = "SELECT * FROM `user_groups` WHERE visible=1";
		return $this->dbo->query($sql);
	}
	public function getUserGroupsForAdmin(){
		$sql = "SELECT * FROM `user_groups` WHERE visible=1 AND groupId!=1";
		return $this->dbo->query($sql);
	}
	public function getUserById($id) {
        $this->dbo->bind("userId","$id");
		$sql = "SELECT u.*, ug.title as `role`, DATE_FORMAT(u.created_at, '$this->dateFormat') as `created_at`
				FROM `users` as u
				INNER JOIN `user_groups` as ug
				ON u.groupId = ug.groupId
				WHERE u.userId=:userId
				AND u.userType = 'user'
				AND u.`deleted`=0";
		$result = $this->dbo->row($sql);
		unset($result['password']);
		return $result;
	}
	public function getUserOrTeamById($id) {
        $this->dbo->bind("userId","$id");
		$sql = "SELECT u.*, ug.title as `role`, DATE_FORMAT(u.created_at, '$this->dateFormat') as `created_at`
				FROM `users` as u
				INNER JOIN `user_groups` as ug
				ON u.groupId = ug.groupId
				WHERE u.userId=:userId
				AND u.`deleted`=0";
		$result = $this->dbo->row($sql);
		unset($result['password']);
		return $result;
	}
	public function getUserGroupById($userId){
        $this->dbo->bind("userId","$userId");
		$sql = "SELECT groupId FROM users WHERE userId=:userId AND deleted=0";
		return $this->dbo->row($sql)['groupId'];
	}
	public function isUserInGroup($userId, $groups) {
		$groups[]= 1; //add Top Admin (always allowed to do anything what a boss)
		$len = count($groups);
		if($len <=0){return false;}
		$wot = array();
		for($i=0; $i<$len; $i++) {
			$wot[] = '?';
		}
		$binds = $groups;
		array_unshift($binds, $userId);
		$groupsText = implode(',', $wot);
		$sql = "SELECT userId FROM users as u
				INNER JOIN user_groups as ug
				ON u.groupId = ug.groupId
				WHERE userId=?
				AND (ug.groupId IN (${groupsText}))
				AND u.deleted=0
				AND u.active=1";
		return !empty($this->dbo->row($sql, $binds));
	}
	public function isUserInGroupStrict($userId, $groups) {
		$groups[]= -1;
		$len = count($groups);
		if($len <=0){return false;}
		$wot = array();
		for($i=0; $i<$len; $i++) {
			$wot[] = '?';
		}
		$binds = $groups;
		array_unshift($binds, $userId);
		$groupsText = implode(',', $wot);
		$sql = "SELECT userId FROM users as u
				INNER JOIN user_groups as ug
				ON u.groupId = ug.groupId
				WHERE userId=?
				AND (ug.groupId IN (${groupsText}))
				AND u.deleted=0
				AND u.active=1";
		return !empty($this->dbo->row($sql, $binds));
	}
	//CREATE & UPDATE
	public function createUser($params){
		extract($params, EXTR_SKIP);
		$password = password_hash($password, PASSWORD_DEFAULT);
		$bindArray = array(
			"groupId"    	=>	"$groupId",
			"fullname"   	=>	"$fullname",
			"username"   	=>	"$username",
			"password"   	=>	"$password",
			"mobile"   		=>	"$mobile",
			"amiantitId"   	=>	"$amiantitId",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "INSERT IGNORE INTO `users` SET `userType`= 'user', `groupId`=:groupId, `fullname`=:fullname,
				`username`=:username, `password`=:password, `mobile`=:mobile, `amiantitId`=:amiantitId";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function updateUser($params){
		extract($params, EXTR_SKIP);
		$withPassword = "";
		$password = isset($password) ? $password : "";
		$bindArray = array(
			"userId"    	=>	"$userId",
			"groupId"    	=>	"$groupId",
			"fullname"   	=>	"$fullname",
			"username"   	=>	"$username",
			"mobile"   		=>	"$mobile",
			"amiantitId"   	=>	"$amiantitId",
		);
		if($password != "") {
			$password = password_hash($password, PASSWORD_DEFAULT);
			$withPassword = ", `password`=:password";
			$bindArray["password"] = $password;
		}
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `users` SET `groupId`=:groupId, `fullname`=:fullname,
				`username`=:username $withPassword, `mobile`=:mobile, `amiantitId`=:amiantitId
				WHERE `userId`=:userId
				AND userType='user'";
		return $this->dbo->query($sql);
	}
	public function usernameAvailable($username, $exceptionId=0){
		$this->dbo->bindMore(array(
			"username"=>"$username",
			"exceptionId"=>"$exceptionId",
		));
		$sql = "SELECT userId FROM users 
				WHERE LOWER(username)=LOWER(:username)
				AND userId!=:exceptionId
				AND deleted=0";
		return empty($this->dbo->row($sql));
	}
	public function isUserMobileAvailable($mobile, $exceptionId=0){
		$this->dbo->bindMore(array(
			"mobile"=>"$mobile",
			"exceptionId"=>"$exceptionId",
		));
		$sql = "SELECT userId 
				FROM users
				WHERE mobile=:mobile
				AND userType='user'
				AND deleted=0
				AND userId!=:exceptionId";
		return empty($this->dbo->row($sql));
	}
	public function isWorkerAndUserAmiantitIdAvailable($amiantitId, $exceptionId=0){
		$this->dbo->bindMore(array(
			"amiantitId"=>"$amiantitId",
			"exceptionId"=>"$exceptionId",
		));
		$sql = "SELECT DISTINCT x.amiantitId
				FROM (
					SELECT amiantitId FROM `workers` as w WHERE w.deleted=0 
					UNION 
					SELECT amiantitId FROM `users` as u WHERE u.deleted=0 
				)
				as x
				WHERE x.amiantitId IS NOT NULL
				AND x.amiantitId != 0
				AND x.amiantitId=:amiantitId
				AND x.amiantitId!=:exceptionId";
		return empty($this->dbo->row($sql));
	}
	public function isWorkerAmiantitIdAvailable($amiantitId, $exceptionId=0){
		$this->dbo->bindMore(array(
			"amiantitId"=>"$amiantitId",
			"exceptionId"=>"$exceptionId",
		));
		$sql = "SELECT DISTINCT x.amiantitId
				FROM (
					SELECT amiantitId FROM `workers` as w WHERE w.deleted=0 
				)
				as x
				WHERE x.amiantitId IS NOT NULL
				AND x.amiantitId != 0
				AND x.amiantitId=:amiantitId
				AND x.amiantitId!=:exceptionId";
		return empty($this->dbo->row($sql));
	}
	public function isUserAmiantitIdAvailable($amiantitId, $exceptionId=0){
		$this->dbo->bindMore(array(
			"amiantitId"=>"$amiantitId",
			"exceptionId"=>"$exceptionId",
		));
		$sql = "SELECT DISTINCT x.amiantitId
				FROM (
					SELECT amiantitId FROM `users` as u WHERE u.deleted=0 
				)
				as x
				WHERE x.amiantitId IS NOT NULL
				AND x.amiantitId != 0
				AND x.amiantitId=:amiantitId
				AND x.amiantitId!=:exceptionId";
		return empty($this->dbo->row($sql));
	}
	//CREATE & UPDATE
	public function createUserTransaction($params){
		extract($params, EXTR_SKIP);
		try {
			$this->dbo->beginTransaction();
			$result = $this->createUser($params);
			$this->dbo->executeTransaction();
			return $result;
		}
		catch(Exception $e) {
			$this->dbo->rollBack();
			return false;
		}
    }
	public function updateUserTransaction($params){
		extract($params, EXTR_SKIP);
		try {
			$this->dbo->beginTransaction();
			$this->updateUser($params);
			$this->dbo->executeTransaction();
			return true;
		}
		catch(Exception $e) {
			$this->dbo->rollBack();
			return false;
		}
    }
	public function updateUserActive($userId, $active) {
		$bindArray = array(
			"userId"	=>	"$userId",
			"active"	=>	"$active"
		);
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `users` SET active=:active WHERE userId=:userId";
		return $this->dbo->query($sql);
	}
	//DELETE
	public function deleteUser($userId){
		$this->dbo->bind("userId","$userId");
		$sql = "UPDATE `users` SET deleted=1 WHERE `userId`=:userId";
		return $this->dbo->query($sql);
	}
	/* #endregion */	
	
	/* #region	WORKERS  */
	//----------------------------------------------------------------
	//
	//						WORKERS
	//
	//----------------------------------------------------------------
	//VIEW
	public function getAllWorkers(){
		$sql = "SELECT w.*, u.fullname
				FROM workers as w
				INNER JOIN users as u
				ON w.userId = u.userId
				AND u.userType='team'
				AND w.deleted = 0
				ORDER BY w.workerId, u.userId ASC";
		return $this->dbo->query($sql);
	}
	public function getWorkerById($id) {
        $this->dbo->bind("workerId","$id");
		$sql = "SELECT w.*, u.fullname 
				FROM workers as w
				INNER JOIN users as u
				ON w.userId = u.userId
				AND u.userType='team'
				AND w.deleted = 0
				AND w.workerId = :workerId";
		return $this->dbo->row($sql);
	}
	//CREATE & UPDATE
	public function createWorker($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"workerName"   	=>	"$workerName",
			"userId"    	=>	"$userId",
			"amiantitId"    =>	"$amiantitId",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "INSERT IGNORE INTO `workers` SET `workerName`=:workerName, `userId`=:userId, `amiantitId`=:amiantitId";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function updateWorker($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"workerId"   	=>	"$workerId",
			"workerName"   	=>	"$workerName",
			"userId"    	=>	"$userId",
			"amiantitId"    =>	"$amiantitId",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `workers` SET `workerName`=:workerName, `userId`=:userId, `amiantitId`=:amiantitId WHERE workerId=:workerId";
		return $this->dbo->query($sql);
	}
	//CREATE & UPDATE
	public function createWorkerTransaction($params){
		extract($params, EXTR_SKIP);
		try {
			$this->dbo->beginTransaction();
			$result = $this->createWorker($params);
			$workerId = $result;
			$hasUserId = isset($params['userId']) ? $params['userId'] : false;
			if($hasUserId) {
				$this->addWorkerToTeam($workerId, $userId);
			}
			$this->dbo->executeTransaction();
			return $result;
		}
		catch(Exception $e) {
			$this->dbo->rollBack();
			return false;
		}
    }
	public function updateWorkerTransaction($params){
		extract($params, EXTR_SKIP);
		try {
			$this->dbo->beginTransaction();
			$hasUserId = isset($params['userId']) ? $params['userId'] : false;
			if($hasUserId) {
				if(!$this->isWorkerInTeam($workerId, $userId)) {
					$this->addWorkerToTeam($workerId, $userId);
				}
			}
			$this->updateWorker($params);
			$this->dbo->executeTransaction();
			return true;
		}
		catch(Exception $e) {
			$this->dbo->rollBack();
			return false;
		}
    }
	//DELETE
	public function deleteWorker($workerId){
		$this->dbo->bind("workerId","$workerId");
		$sql = "UPDATE `workers` SET deleted=1 WHERE `workerId`=:workerId";
		return $this->dbo->query($sql);
	}
    public function isWorkerInTeam($workerId, $userId) {
		$bindArray = array(
			"workerId"    	=>	"$workerId",
			"userId"   		=>	"$userId",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "SELECT workerId FROM `workers`
				WHERE `workerId`=:workerId
				AND `userId`=:userId";
		return !empty($this->dbo->row($sql));
	}
    public function addWorkerToTeam($workerId, $userId) {
		$bindArray = array(
			"workerId"    =>	"$workerId",
			"userId"   	=>		"$userId",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "INSERT IGNORE INTO `worker_team` SET `workerId`=:workerId, `userId`=:userId";
		return $this->dbo->query($sql);
	}
	public function updateWorkerTeam($workerId, $userId){
		$bindArray = array(
			"workerId"  	=>	"$workerId",
			"userId"   		=>	"$userId",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE IGNORE `workers` SET userId=:userId WHERE `workerId`=:workerId";
		return $this->dbo->query($sql);
	}
	public function removeWorkersFromTeam($newWorkerIds, $userId){
		$oldWorkersIds = $this->getTeamWorkersIds($userId);
		//we need to reset workers that are not in old team & not in new team (workers that don't have team anymore)
		//e.g. the team's old workers are [1,2,3,4], new workers of the team are [2,3] we reset [1,4] since they no longer have a team
		$workersIdsToReset = array_values(array_diff($oldWorkersIds, $newWorkerIds));
		if(count($workersIdsToReset) > 0) {
			foreach($workersIdsToReset as $workerId) {
				$this->updateWorkerTeam($workerId, None); 
				$this->addWorkerToTeam($workerId, None);
			}
		}
		return true;
	}
    public function addWorkersToTeam($workers, $userId) {
		//should be used only inside a transaction
		if(count($workers) > 0) {
			foreach($workers as $workerId) {
				if(!$this->isWorkerInTeam($workerId, $userId)) {
					$this->updateWorkerTeam($workerId, $userId);
					$this->addWorkerToTeam($workerId, $userId);
				}
			}
			return true;
		}
		return false;
	}
	public function getWorkerTeamJoins($userId){
		$this->dbo->bind("userId","$userId");
		$sql = "SELECT wt.joinId FROM worker_team as wt
				INNER JOIN workers as w
				ON wt.workerId = w.workerId
				WHERE wt.userId=:userId
				AND w.deleted = 0";
		$result = $this->dbo->query($sql);
		if(!empty($result)) {
			return array_column($result, 'joinId');
		}
		return null;
	}
    public function giveTeamWorkersCredit($stageId, $joins=array()) {
		if(intval($stageId) <= 0){return false;}
		if(count($joins) <= 0){return false;}
		$values = '';
		$length = count($joins);
        $sql = "INSERT IGNORE INTO `worker_credits` (`stageId`, `joinId`) VALUES ";
        for($i=0; $i<$length; $i++) {
            $values .= "($stageId,?), ";
        }
        $sql .= trim($values, ', ');
        return $this->dbo->query($sql, $joins);
    }
	/* #endregion */	
	
	/* #region	CUSTOMERS */
	//----------------------------------------------------------------
	//
	//						CUSTOMERS
	//
	//----------------------------------------------------------------
	//VIEW
	
	public function getAllCustomers(){
		$sql = "SELECT *,
				DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `customers` 
				WHERE `deleted`=0
				ORDER BY customerId ASC";
		return $this->dbo->query($sql);
	}
	public function getCustomerById($id){
        $this->dbo->bind("customerId","$id");
		$sql = "SELECT *,
				DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `customers`
				WHERE customerId=:id
				AND deleted=0";
		return $this->dbo->row($sql);
	}
	public function isCustomerSAPAvailable($SAP, $exceptionId=0){
		$this->dbo->bindMore(array(
			"SAP"=>"$SAP",
			"exceptionId"=>"$exceptionId",
		));
		$sql = "SELECT customerId 
				FROM customers
				WHERE SAP=:SAP
				AND deleted=0
				AND customerId!=:exceptionId";
		return empty($this->dbo->row($sql));
	}
	// public function isCustomerMobileAvailable($mobile, $exceptionId=0){
	// 	$this->dbo->bindMore(array(
	// 		"mobile"=>"$mobile",
	// 		"exceptionId"=>"$exceptionId",
	// 	));
	// 	$sql = "SELECT customerId 
	// 			FROM customers
	// 			WHERE mobile=:mobile
	// 			AND deleted=0
	// 			AND customerId!=:exceptionId";
	// 	return empty($this->dbo->row($sql));
	// }
	//CREATE & UPDATE
	public function createCustomer($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"customerName"		    =>	"$customerName",
			"SAP"				=>	"$SAP",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "INSERT IGNORE INTO `customers` SET `customerName`=:customerName, SAP=:SAP";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function updateCustomer($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"customerId"		=>	"$customerId",
			"customerName"		    =>	"$customerName",
			"SAP"		=>	"$SAP",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `customers` SET `customerName`=:customerName, SAP=:SAP WHERE customerId=:customerId";
		return $this->dbo->query($sql);
	}
	//DELETE
	public function deleteCustomer($customerId){
		$this->dbo->bind("customerId","$customerId");
		$sql = "UPDATE `customers` SET deleted=1 WHERE customerId=:customerId";
		return $this->dbo->query($sql);
	}
	/* #endregion */

	/* #region	Centers */
	//----------------------------------------------------------------
	//
	//						Centers
	//
	//----------------------------------------------------------------
	//VIEW
	
	public function getAllCenters(){
		$sql = "SELECT *,
				DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `centers` 
				WHERE `deleted`=0
				ORDER BY centerId ASC";
		return $this->dbo->query($sql);
	}
	public function getCenterById($id){
        $this->dbo->bind("centerId","$id");
		$sql = "SELECT *,
				DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `centers`
				WHERE centerId=:id
				AND deleted=0";
		return $this->dbo->row($sql);
	}
	//CREATE & UPDATE
	public function createCenter($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"centerName"    =>	"$centerName",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "INSERT IGNORE INTO `centers` SET `centerName`=:centerName";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function updateCenter($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"centerId"		=>	"$centerId",
			"centerName"    =>	"$centerName",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `centers` SET `centerName`=:centerName WHERE centerId=:centerId";
		return $this->dbo->query($sql);
	}
	//DELETE
	public function deleteCenter($centerId){
		$this->dbo->bind("centerId","$centerId");
		$sql = "UPDATE `centers` SET deleted=1 WHERE centerId=:centerId";
		return $this->dbo->query($sql);
	}
	/* #endregion */

	/* #region	SPOOL TYPES */
	//----------------------------------------------------------------
	//
	//						Spool Types
	//
	//----------------------------------------------------------------
	//VIEW
	
	public function getAllSpoolTypes(){
		$sql = "SELECT * FROM spool_types";
		return $this->dbo->query($sql);
	}
	public function getSpoolTypeById($spoolTypeId){
        $this->dbo->bind("id","$spoolTypeId");
		$sql = "SELECT *,
				DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `spool_types`
				WHERE spoolTypeId=:id
				AND deleted=0";
		return $this->dbo->row($sql);
	}
	//CREATE & UPDATE
	public function createSpoolType($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"spoolTypeName"    =>	"$spoolTypeName",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "INSERT IGNORE INTO `spool_types` SET `spoolTypeName`=:spoolTypeName";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function updateSpoolType($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"spoolTypeId"		=>	"$spoolTypeId",
			"spoolTypeName"    	=>	"$spoolTypeName",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `spool_types` SET `spoolTypeName`=:spoolTypeName WHERE spoolTypeId=:spoolTypeId";
		return $this->dbo->query($sql);
	}
	//DELETE
	public function deleteSpoolType($spoolTypeId){
		$this->dbo->bind("spoolTypeId","$spoolTypeId");
		$sql = "UPDATE `spool_types` SET deleted=1 WHERE spoolTypeId=:spoolTypeId";
		return $this->dbo->query($sql);
	}
	/* #endregion */

	/* #region	Locations */
	//----------------------------------------------------------------
	//
	//						Locations
	//
	//----------------------------------------------------------------
	//VIEW
	
	public function getAllLocations(){
		$sql = "SELECT * FROM locations";
		return $this->dbo->query($sql);
	}
	public function getLocationById($locationId){
        $this->dbo->bind("id","$locationId");
		$sql = "SELECT *, DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `locations`
				WHERE locationId=:id
				AND deleted=0";
		return $this->dbo->row($sql);
	}
	//CREATE & UPDATE
	public function createLocation($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"locationName"    =>	"$locationName",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "INSERT IGNORE INTO `locations` SET `locationName`=:locationName";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function updateLocation($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"locationId"		=>	"$locationId",
			"locationName"    	=>	"$locationName",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `locations` SET `locationName`=:locationName WHERE locationId=:locationId";
		return $this->dbo->query($sql);
	}
	//DELETE
	public function deleteLocation($locationId){
		$this->dbo->bind("locationId","$locationId");
		$sql = "UPDATE `locations` SET deleted=1 WHERE locationId=:locationId";
		return $this->dbo->query($sql);
	}
	/* #endregion */

	/* #region	Stations */
	//----------------------------------------------------------------
	//
	//						Stations
	//
	//----------------------------------------------------------------
	//VIEW
	
	public function getAllStations(){
		$sql = "SELECT s.*, c.centerName,
				DATE_FORMAT(s.created_at, '$this->dateFormat') as `created_at`
				FROM `stations` as s
				INNER JOIN `centers` as c
				ON s.centerId = c.centerId
				WHERE s.`deleted`=0
				ORDER BY s.stationId ASC";
		return $this->dbo->query($sql);
	}
	public function getStationById($id){
        $this->dbo->bind("stationId","$id");
		$sql = "SELECT *,
				DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `stations`
				WHERE stationId=:id
				AND deleted=0";
		return $this->dbo->row($sql);
	}
	//CREATE & UPDATE
	public function createStation($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"centerId"    	=>	"$centerId",
			"stationName"   =>	"$stationName",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "INSERT IGNORE INTO `stations` SET `stationName`=:stationName, `centerId`=:centerId";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function updateStation($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"stationId"  	=>	"$stationId",
			"centerId"   	=>	"$centerId",
			"stationName"   =>	"$stationName",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `stations` SET `stationName`=:stationName, `centerId`=:centerId WHERE stationId=:stationId";
		return $this->dbo->query($sql);
	}
	//DELETE
	public function deleteStation($stationId){
		$this->dbo->bind("stationId","$stationId");
		$sql = "UPDATE `stations` SET deleted=1 WHERE `stationId`=:stationId";
		return $this->dbo->query($sql);
	}
	/* #endregion */

	/* #region	Projects */
	//----------------------------------------------------------------
	//
	//						Projects
	//
	//----------------------------------------------------------------
	//VIEW
	
	public function getAllProjects(){
		$sql = "SELECT p.*, c.customerName,
				DATE_FORMAT(p.created_at, '$this->dateFormat') as `created_at`
				FROM `projects` as p
				INNER JOIN `customers` as c
				ON p.customerId = c.customerId
				WHERE p.`deleted`=0
				ORDER BY p.projectId ASC";
		return $this->dbo->query($sql);
	}
	public function getProjectById($id){
        $this->dbo->bind("projectId","$id");
		$sql = "SELECT *,
				DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `projects`
				WHERE projectId=:id
				AND deleted=0";
		return $this->dbo->row($sql);
	}
	//CREATE & UPDATE
	public function createProject($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"customerId"    =>	"$customerId",
			"projectName"   =>	"$projectName",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "INSERT IGNORE INTO `projects` SET `projectName`=:projectName, `customerId`=:customerId";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function updateProject($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"projectId"  	=>	"$projectId",
			"customerId"   	=>	"$customerId",
			"projectName"   =>	"$projectName",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `projects` SET `projectName`=:projectName, `customerId`=:customerId WHERE projectId=:projectId";
		return $this->dbo->query($sql);
	}
	//DELETE
	public function deleteProject($projectId){
		$this->dbo->bind("projectId","$projectId");
		$sql = "UPDATE `projects` SET deleted=1 WHERE `projectId`=:projectId";
		return $this->dbo->query($sql);
	}
	/* #endregion */

	/* #region	RAW MATERIALS */
	//----------------------------------------------------------------
	//
	//						Raw Materials
	//
	//----------------------------------------------------------------
	//VIEW
	
	public function getAllMaterials(){
		$sql = "SELECT *,
				DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `materials` 
				WHERE `deleted`=0
				ORDER BY materialId ASC";
		return $this->dbo->query($sql);
	}
	public function getMaterialById($materialId){
        $this->dbo->bind("materialId","$materialId");
		$sql = "SELECT *,
				DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `materials`
				WHERE materialId=:materialId
				AND deleted=0";
		return $this->dbo->row($sql);
	}
	//CREATE & UPDATE
	public function createMaterial($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"materialType"    =>	"$materialType",
			"materialName"    =>	"$materialName",
			"unit"    		  =>	"$unit",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "INSERT IGNORE INTO `materials` SET `materialType`=:materialType, `materialName`=:materialName, unit=:unit";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function updateMaterial($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"materialId"		=>	"$materialId",
			"materialType"      =>	"$materialType",
			"materialName"    	=>	"$materialName",
			"unit"    			=>	"$unit",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `materials` SET `materialType`=:materialType, `materialName`=:materialName, unit=:unit WHERE materialId=:materialId";
		return $this->dbo->query($sql);
	}
	//DELETE
	public function deleteMaterial($materialId){
		$this->dbo->bind("materialId","$materialId");
		$sql = "UPDATE `materials` SET deleted=1 WHERE materialId=:materialId";
		return $this->dbo->query($sql);
	}
	/* #endregion */
	
	/* #region	PROCESSES */
	//----------------------------------------------------------------
	//
	//						PROCESSES
	//
	//----------------------------------------------------------------
	//VIEW
	
	public function getAllProcesses(){
		$sql = "SELECT *,
				DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `processes` 
				WHERE `deleted`=0
				AND `processId`!=0
				ORDER BY processId ASC";
		return $this->dbo->query($sql);
	}
	public function getProcessById($processId){
        $this->dbo->bind("processId","$processId");
		$sql = "SELECT *,
				DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `processes`
				WHERE processId=:processId
				AND `processId`!=0
				AND deleted=0";
		return $this->dbo->row($sql);
	}
	//CREATE & UPDATE
	public function createProcess($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"processName"    =>	"$processName",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "INSERT IGNORE INTO `processes` SET `processName`=:processName";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function updateProcess($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"processId"			=>	"$processId",
			"processName"    	=>	"$processName",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `processes` SET `processName`=:processName WHERE processId=:processId";
		return $this->dbo->query($sql);
	}
	public function lockProcess($processId, $userId){
		return $this->updateProcessUserId($processId, $userId);
	}
	public function unlockProcess($processId){
		return $this->updateProcessUserId($processId, NULL);
	}
	public function updateProcessUserId($processId, $userId){
		$bindArray = array(
			"processId"			=>	"$processId",
			"userId"			=>	$userId,
		);
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `processes` SET `userId`=:userId WHERE processId=:processId";
		return $this->dbo->query($sql);
	}
	
	//DELETE
	public function deleteProcess($processId){
		$this->dbo->bind("processId","$processId");
		$sql = "UPDATE `processes` SET deleted=1 WHERE processId=:processId";
		return $this->dbo->query($sql);
	}
	/* #endregion */
	
	/* #region	TEAMS */
	//----------------------------------------------------------------
	//
	//						TEAMS
	//
	//----------------------------------------------------------------
	//VIEW
	public function getAllTeams(){
		$sql = "SELECT *, DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `users` 
				WHERE `userType`='team'
				AND `deleted`=0
				ORDER BY userId ASC";
		return $this->dbo->query($sql);
	}
	public function getAllVisibleTeams(){
		$sql = "SELECT *, DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `users` 
				WHERE `userType`='team'
				AND `deleted`=0
				AND `visible`=1
				ORDER BY userId ASC";
		return $this->dbo->query($sql);
	}
	public function getTeamById($userId){
        $this->dbo->bind("userId","$userId");
		$sql = "SELECT *, DATE_FORMAT(created_at, '$this->dateFormat') as `created_at`
				FROM `users`
				WHERE `userType`='team'
				AND userId=:userId
				AND deleted=0";
		$result = $this->dbo->row($sql);
		unset($result['password']);
		return $result;
	}
	public function isTeamEmpty($userId){
        $this->dbo->bind("userId","$userId");
		$sql = "SELECT *
				FROM `workers`
				WHERE userId=:userId
				AND deleted=0";
		return empty($this->dbo->row($sql));
	}
	public function getTeamWorkers($userId){
        $this->dbo->bind("userId","$userId");
		$sql = "SELECT *
				FROM `workers`
				WHERE userId=:userId
				AND deleted=0";
		return $this->dbo->query($sql);
	}
	public function getTeamWorkersIds($userId){
        $this->dbo->bind("userId","$userId");
		$sql = "SELECT workerId
				FROM `workers`
				WHERE userId=:userId
				AND deleted=0";
		$result = $this->dbo->query($sql);
		if(!empty($result)) {
			$result = array_column($result, 'workerId');
		}
		return $result;
	}
	//CREATE & UPDATE
	public function createTeamTransaction($params){
		extract($params, EXTR_SKIP);
		try {
			$this->dbo->beginTransaction();
			$result = $this->createTeam($params);
			$userId = $result;
			$workers = isset($workers) ? $workers : array();
			$this->removeWorkersFromTeam($workers, $userId);
			$this->addWorkersToTeam($workers, $userId);
			$this->dbo->executeTransaction();
			return $result;
		}
		catch(Exception $e) {
			$this->dbo->rollBack();
			return false;
		}
    }
	public function updateTeamTransaction($params){
		extract($params, EXTR_SKIP);
		try {
			$this->dbo->beginTransaction();
			$workers = isset($workers) ? $workers : array();
			$this->removeWorkersFromTeam($workers, $userId);
			$this->addWorkersToTeam($workers, $userId);
			$this->updateTeam($params);
			$this->dbo->executeTransaction();
			return true;
		}
		catch(Exception $e) {
			$this->dbo->rollBack();
			return false;
		}
    }
	public function createTeam($params){
		extract($params, EXTR_SKIP);
		$password = password_hash($password, PASSWORD_DEFAULT);
		$bindArray = array(
			"groupId"    	=>	Team,
			"fullname"   	=>	"$fullname",
			"username"   	=>	"$username",
			"password"   	=>	"$password",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "INSERT IGNORE INTO `users` SET `userType`= 'team', `groupId`=:groupId, `fullname`=:fullname,
				`username`=:username, `password`=:password";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function updateTeam($params){
		extract($params, EXTR_SKIP);
		$withPassword = "";
		$bindArray = array(
			"groupId"    	=>	Team,
			"userId"    	=>	"$userId",
			"fullname"   	=>	"$fullname",
			"username"   	=>	"$username",
		);
		if(!empty($password)) {
			$password = password_hash($password, PASSWORD_DEFAULT);
			$withPassword = ", `password`=:password";
			$bindArray["password"] = $password;
		}
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `users` SET `groupId`=:groupId, `fullname`=:fullname,
				`username`=:username $withPassword
				WHERE `userId`=:userId
				AND userType='team'";
		return $this->dbo->query($sql);
	}
	//DELETE
	public function deleteTeam($userId){
		$this->dbo->bind("userId","$userId");
		$sql = "UPDATE `users` SET deleted=1 WHERE userId=:userId AND userType='team'";
		return $this->dbo->query($sql);
	}
	/* #endregion */
	
	/* #region	ORDERS */
	//----------------------------------------------------------------
	//
	//						Job Orders
	//
	//----------------------------------------------------------------
	//VIEW
	public function getAllOrders(){
		$sql = "SELECT o.*, p.projectName, c.customerName,
				DATE_FORMAT(o.created_at, '$this->dateFormat') as `created_at`
				FROM `orders` as o 
				INNER JOIN `projects` as p
				ON o.projectId = p.projectId
				INNER JOIN `customers` as c
				ON p.customerId = c.customerId
				WHERE o.`deleted`=0
				AND p.deleted = 0
				ORDER BY o.orderId ASC";
		return $this->dbo->query($sql);
	}
	public function getOrderById($orderId){
        $this->dbo->bind("orderId","$orderId");
		$sql = "SELECT o.*, p.projectName, c.customerName,
				DATE_FORMAT(o.created_at, '$this->dateFormat') as `created_at`
				FROM `orders` as o 
				INNER JOIN `projects` as p
				ON o.projectId = p.projectId
				INNER JOIN `customers` as c
				ON p.customerId = c.customerId
				WHERE o.orderId=:orderId
				AND o.`deleted`=0
				AND p.deleted=0";
		return $this->dbo->row($sql);
	}
	//CREATE & UPDATE
	public function createOrder($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"orderNo"    	=>	"$orderNo",
			"projectId"     =>	"$projectId",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "INSERT IGNORE INTO `orders` SET orderNo=:orderNo, projectId=:projectId";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function updateOrder($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"orderId"       =>	"$orderId",
			"orderNo"    	=>	"$orderNo",
			"projectId"     =>	"$projectId",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `orders` SET orderNo=:orderNo, projectId=:projectId WHERE orderId=:orderId";
		return $this->dbo->query($sql);
	}
	/*
	public function createOrderTransaction($params){
		extract($params, EXTR_SKIP);
		$stations = isset($stations) ? $stations : array();
		try {
			$this->dbo->beginTransaction();
			$result = $this->createOrder($params);
			$orderId = $result;
			$this->removeStationsFromOrder($orderId);
			if(count($stations)>0) {
				$this->addStationsToOrder($orderId, $stations);
			}
			$this->dbo->executeTransaction();
			return $result;
		}
		catch(Exception $e) {
			$this->dbo->rollBack();
			return false;
		}
    }
	public function updateOrderTransaction($params){
		extract($params, EXTR_SKIP);
		$stations = isset($stations) ? $stations : array();
		try {
			$this->dbo->beginTransaction();
			$this->updateOrder($params);
			$this->removeStationsFromOrder($orderId);
			if(count($stations)>0) {
				$this->addStationsToOrder($orderId, $stations);
			}
			$this->dbo->executeTransaction();
			return true;
		}
		catch(Exception $e) {
			$this->dbo->rollBack();
			return false;
		}
	}
	*/
	//DELETE
	public function deleteOrderTransaction($orderId){
		try {
			$this->dbo->beginTransaction();
			$this->deleteOrder($orderId);
			$this->deleteOrderLinesAndSpools($orderId);
			return true;
		}
		catch(Exception $e) {
			$this->dbo->rollBack();
			return false;
		}
	}
	public function deleteOrderLinesAndSpools($orderId){
		$this->dbo->bind("orderId","$orderId");
		$sql = "UPDATE spool_lines as sl, spools as s, orders as o
				SET s.deleted=1,sl.deleted=1,o.deleted=1
				WHERE o.orderId=:orderId
				AND sl.orderId = o.orderId
				AND s.lineId = sl.lineId";
		return $this->dbo->query($sql);
	}
	public function deleteOrder($orderId){
		$this->dbo->bind("orderId","$orderId");
		$sql = "UPDATE `orders` SET `deleted`=1 WHERE `orderId`=:orderId";
		return $this->dbo->query($sql);
	}
	/* #endregion */
	/* #region	SPOOL LINES */
	//----------------------------------------------------------------
	//
	//						Job Lines
	//
	//----------------------------------------------------------------
	//VIEW
	public function getAllLines(){
		$sql = "SELECT l.*, st.spoolTypeName, o.orderNo, p.projectName, o.orderId, ROUND(l.spoolQuantity * l.pricePerPiece) as totalPrice,
				DATE_FORMAT(l.created_at, '$this->dateFormat') as `created_at`
				FROM `spool_lines` as l
				INNER JOIN orders as o
				ON l.orderId = o.orderId
				INNER JOIN projects as p
				ON p.projectId = o.projectId
				INNER JOIN spool_types as st
				ON st.spoolTypeId = l.spoolTypeId
				WHERE l.deleted = 0
				AND o.deleted= 0
				AND p.deleted=0";
		return $this->dbo->query($sql);
	}
	public function getLineById($lineId){
        $this->dbo->bind("lineId","$lineId");
		$sql = "SELECT l.*, st.spoolTypeName, o.orderNo, p.projectName, o.orderId, ROUND(l.spoolQuantity * l.pricePerPiece) as totalPrice,
				DATE_FORMAT(l.created_at, '$this->dateFormat') as `created_at`
				FROM `spool_lines` as l
				INNER JOIN orders as o
				ON l.orderId = o.orderId
				INNER JOIN projects as p
				ON p.projectId = o.projectId
				INNER JOIN spool_types as st
				ON st.spoolTypeId = l.spoolTypeId
				WHERE l.deleted = 0
				AND o.deleted= 0
				AND p.deleted=0
				AND l.lineId=:lineId";
		return $this->dbo->row($sql);
	}
	public function getLineMaterials($lineId){
        $this->dbo->bind("lineId","$lineId");
		$sql = "SELECT slm.materialId, m.materialName, slm.quantity FROM `spool_line_materials` as slm
				INNER JOIN `materials` as m
				ON slm.materialId = m.materialId
				WHERE slm.`lineId`=:lineId";
		return $this->dbo->query($sql);
	}
	public function getLineTotalMaterials($lineId){
        $this->dbo->bind("lineId","$lineId");
		$sql = "SELECT slm.lineId,
				SUM(case when m.materialType = 'Resin' then slm.quantity else 0 end) as totalPlannedResin,
				SUM(case when m.materialType = 'Fabric' then slm.quantity else 0 end) as totalPlannedFabric
				FROM spool_line_materials as slm
				INNER JOIN materials as m
				ON m.materialId = slm.materialId
				WHERE slm.lineId = :lineId
				GROUP BY slm.lineId";
		return $this->dbo->row($sql);
	}
	//CREATE & UPDATE
	public function createLineTransaction($params){
		extract($params, EXTR_SKIP);
		try {
			$this->dbo->beginTransaction();
			$result = $this->createLine($params);
			$lineId = $result;
			if(count($materials)>0) {
				$this->addMaterialsToLine($lineId, $materials);
				$subParams = $this->getLineTotalMaterials($lineId);
				$this->updateLinePlannedRisenFabric($subParams);
			}
			//auto generate spool based on line data
			$spoolParams = array('lineId' => $lineId);
			for($i=1; $i<=$spoolQuantity; $i++) {
				$spoolParams['uuid'] = $this->generateUUID();
				$spoolParams['serial'] = $i;
				$this->createSpool($spoolParams);
			}
			$this->dbo->executeTransaction();
			return $result;
		}
		catch(Exception $e) {
			$this->dbo->rollBack();
			return false;
		}
    }
	public function createLine($params){
		extract($params, EXTR_SKIP);
		$pricePerPiece = isset($pricePerPiece) ? $pricePerPiece : 0;
		$plannedHoursPerPiece = isset($plannedHoursPerPiece) ? $plannedHoursPerPiece : 0;
		$spoolDescription = isset($spoolDescription) ? $spoolDescription : "";
		$bindArray = array(
			"orderId"    			=>	"$orderId",
			"lineNo"    			=>	"$lineNo",
			"spoolNo"    			=>	"$spoolNo",
			"spoolTypeId"    		=>	"$spoolTypeId",
			"spoolDN"    			=>	"$spoolDN",
			"spoolDescription"    	=>	"$spoolDescription",
			"spoolQuantity"     	=>	"$spoolQuantity",
			"pricePerPiece"     	=>	"$pricePerPiece",
			"plannedHoursPerPiece"  =>	"$plannedHoursPerPiece",
		);
		$this->dbo->bindMore($bindArray);
		$sets = $this->getSetsText($bindArray);
		$sql = "INSERT IGNORE INTO `spool_lines` SET ${sets}";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function updateLineTransaction($params){
		extract($params, EXTR_SKIP);
		try {
			$this->dbo->beginTransaction();
			$result = $this->updateLine($params);
			if(count($materials)>0) {
				$this->removeMaterialsFromLine($lineId);
				$this->addMaterialsToLine($lineId, $materials);
				$subParams = $this->getLineTotalMaterials($lineId);
				$this->updateLinePlannedRisenFabric($subParams);
			}
			$this->dbo->executeTransaction();
			return $result;
		}
		catch(Exception $e) {
			$this->dbo->rollBack();
			return false;
		}
    }
	public function updateLine($params){
		extract($params, EXTR_SKIP);
		$pricePerPiece = isset($pricePerPiece) ? $pricePerPiece : 0;
		$plannedHoursPerPiece = isset($plannedHoursPerPiece) ? $plannedHoursPerPiece : 0;
		$spoolDescription = isset($spoolDescription) ? $spoolDescription : "";
		$bindArray = array(
			"lineId"    			=>	"$lineId",
			"orderId"    			=>	"$orderId",
			"lineNo"    			=>	"$lineNo",
			"spoolNo"    			=>	"$spoolNo",
			"spoolTypeId"    		=>	"$spoolTypeId",
			"spoolDN"    			=>	"$spoolDN",
			"spoolDescription"    	=>	"$spoolDescription",
			"pricePerPiece"     	=>	"$pricePerPiece",
			"plannedHoursPerPiece"  =>	"$plannedHoursPerPiece",
		);
		$sets = $this->getSetsText($bindArray, array('lineId'));
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `spool_lines` SET ${sets} WHERE lineId=:lineId";
		return $this->dbo->query($sql);
	}
	public function updateLinePlannedRisenFabric($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"lineId"    			   =>	"$lineId",
			"plannedFabricPerPiece"    =>	"$totalPlannedFabric",
			"plannedResinPerPiece"     =>	"$totalPlannedResin",
		);
		$sets = $this->getSetsText($bindArray, array('lineId'));
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `spool_lines` SET ${sets} WHERE lineId=:lineId";
		return $this->dbo->query($sql);
	}
	//DELETE
	public function deleteLineTransaction($lineId){
		try {
			$this->dbo->beginTransaction();
			$this->deleteLine($lineId);
			$this->deleteLineSpools($lineId);
			return true;
		}
		catch(Exception $e) {
			$this->dbo->rollBack();
			return false;
		}
	}
	public function deleteLine($lineId){
		$this->dbo->bind("lineId","$lineId");
		$sql = "UPDATE `spool_lines` SET deleted=1 WHERE lineId=:lineId";
		return $this->dbo->query($sql);
	}
	public function deleteLineSpools($lineId){
		$this->dbo->bind("lineId","$lineId");
		$sql = "UPDATE `spools` SET deleted=1 WHERE lineId=:lineId";
		return $this->dbo->query($sql);
	}
	/* #endregion */
	/* #region	SPOOL LINES */
	//----------------------------------------------------------------
	//
	//						Job Spools
	//
	//----------------------------------------------------------------
	//VIEW
	public function getAllSpools(){
		$sql = "SELECT s.*, sl.lineId, sl.lineNo, sl.spoolNo, c.customerName, p.projectName, o.orderNo,
				concat(LEFT(sl.spoolDescription , 20), '...') as subDescription,
				DATE_FORMAT(s.created_at, '$this->dateFormat') as `created_at`
				FROM `spools` as s
				INNER JOIN spool_lines as sl
				ON s.lineId = sl.lineId
				INNER JOIN orders as o
				ON sl.orderId = o.orderId
				INNER JOIN projects as p
				ON o.projectId = p.projectId
				INNER JOIN customers as c
				ON c.customerId = p.customerId
				AND s.deleted = 0
				AND sl.deleted= 0
				AND o.deleted = 0
				AND p.deleted = 0";
		return $this->dbo->query($sql);
	}
	public function getSpoolById($spoolId){
        $this->dbo->bind("spoolId","$spoolId");
		$sql = "SELECT s.*, o.orderId, o.orderNo, c.customerName, p.projectName, c.SAP, sl.lineId, sl.lineNo, sl.spoolQuantity, sl.spoolNo,
				concat('$this->qrcodeBase', s.uuid) as qrcode,
				DATE_FORMAT(s.created_at, '$this->dateFormat') as `created_at`
				FROM `spools` as s
				INNER JOIN spool_lines as sl
				ON s.lineId = sl.lineId
				INNER JOIN orders as o
				ON sl.orderId = o.orderId
				INNER JOIN projects as p
				ON o.projectId = p.projectId
				INNER JOIN customers as c
				ON c.customerId = p.customerId
				AND s.deleted = 0
				AND sl.deleted= 0
				AND o.deleted = 0
				AND p.deleted = 0
				AND s.spoolId=:spoolId";
		return $this->dbo->row($sql);
	}
	public function getSpoolStatusById($spoolId){
        $this->dbo->bind("spoolId","$spoolId");
		$sql = "SELECT `status` FROM spools 
				WHERE spoolId=:spoolId";
		return $this->dbo->row($sql)['status'];
	}
	public function getSpoolByUUID($uuid){
		$this->dbo->bind("uuid","$uuid");
		$sql = "SELECT s.*, o.orderId, o.orderNo, c.customerName, p.projectName, c.SAP, sl.lineId, sl.lineNo, sl.spoolQuantity, sl.spoolNo,
				DATE_FORMAT(s.created_at, '$this->dateFormat') as `created_at`
				FROM `spools` as s
				INNER JOIN spool_lines as sl
				ON s.lineId = sl.lineId
				INNER JOIN orders as o
				ON sl.orderId = o.orderId
				INNER JOIN projects as p
				ON o.projectId = p.projectId
				INNER JOIN customers as c
				ON c.customerId = p.customerId
				AND s.deleted = 0
				AND sl.deleted= 0
				AND o.deleted = 0
				AND p.deleted = 0
				AND s.uuid=:uuid";
		return $this->dbo->row($sql);
	}
	public function getSpoolStagesById($spoolId){
		$this->dbo->bind("spoolId","$spoolId");
		//stageId 3 & 4 are for quality assurance only
		$sql = "SELECT ss.*, u.fullname, u.userType, l.locationName, p.processName, st.stageName, IF(ss.stageTypeId IN (3,4), 1, 0) as 'isQuality',
				DATE_FORMAT(ss.created_at, '$this->dateFormat') as `created_at`
				FROM spool_stages as ss
				INNER JOIN processes as p
				ON ss.processId = p.processId
				INNER JOIN stage_types as st
				ON ss.stageTypeId = st.stageTypeId
				INNER JOIN locations as l
				ON ss.locationId = l.locationId
				INNER JOIN users as u
				ON ss.userId = u.userId
				WHERE ss.spoolId=:spoolId
				ORDER BY ss.created_at ASC";
		return $this->dbo->query($sql);
	}
	public function getSpoolLastStageById($spoolId){
		$this->dbo->bind("spoolId","$spoolId");
		$sql = "SELECT ss.*, u.fullname, u.userType, l.locationName, p.processName, st.stageName, IF(ss.stageTypeId IN (3,4), 1, 0) as 'isQuality',
				IF(ss.stageTypeId = 1, 1, 0) as 'canScanOut',
				IF(ss.stageTypeId = 2, 1, 0) as 'canQualityCheck',
				DATE_FORMAT(ss.created_at, '$this->dateFormat') as `created_at`
				FROM spool_stages as ss
				INNER JOIN processes as p
				ON ss.processId = p.processId
				INNER JOIN stage_types as st
				ON ss.stageTypeId = st.stageTypeId
				INNER JOIN locations as l
				ON ss.locationId = l.locationId
				INNER JOIN users as u
				ON ss.userId = u.userId
				WHERE ss.spoolId=:spoolId
				ORDER BY ss.stageId DESC";
		return $this->dbo->row($sql);
	}
	public function getStageById($stageId){
		$this->dbo->bind("stageId","$stageId");
		$sql = "SELECT * FROM spool_stages WHERE stageId=:stageId";
		return $this->dbo->row($sql);
	}
	//CREATE & UPDATE
	public function createSpool($params){
		extract($params, EXTR_SKIP);
		$scheduledDeliveryDate = isset($scheduledDeliveryDate) ? "$scheduledDeliveryDate" : null;
		$productionOrder = isset($productionOrder) ? $productionOrder : "";
		$bindArray = array(
			"lineId"    				=>	"$lineId",
			"serial"    				=>	"$serial",
			"scheduledDeliveryDate"    	=>	$scheduledDeliveryDate,
			"uuid"    					=>	"$uuid",
			"productionOrder"    		=>	"$productionOrder",
		);
		$this->dbo->bindMore($bindArray);
		$sets = $this->getSetsText($bindArray);
		$sql = "INSERT IGNORE INTO `spools` SET ${sets}";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function updateSpool($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"spoolId"    				=>	"$spoolId",
			"scheduledDeliveryDate"    	=>	"$scheduledDeliveryDate",
			"productionOrder"    		=>	"$productionOrder",
			"status"    				=>	"$status",
		);
		$sets = $this->getSetsText($bindArray, array('spoolId'));
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `spools` SET ${sets} WHERE spoolId=:spoolId";
		return $this->dbo->query($sql);
	}
	public function updateSpoolStatus($spoolId, $status){
		$bindArray = array(
			"spoolId"    				=>	"$spoolId",
			"status"    				=>	"$status",
		);
		$this->dbo->bindMore($bindArray);
		$sql = "UPDATE `spools` SET `status`=:status WHERE spoolId=:spoolId";
		return $this->dbo->query($sql);
	}

	// public function updateSpool($params){
	// 	extract($params, EXTR_SKIP);
	// 	$bindArray = array(
	// 		"spoolId"    				=>	"$spoolId",
	// 		"lineId"    				=>	"$lineId",
	// 		"serial"    				=>	"$serial",
	// 		"scheduledDeliveryDate"    	=>	"$scheduledDeliveryDate",
	// 		"uuid"    					=>	"$uuid",
	// 		"productionOrder"    		=>	"$productionOrder",
	// 	);
	// 	$sets = $this->getSetsText($bindArray, array('spoolId'));
	// 	$this->dbo->bindMore($bindArray);
	// 	$sql = "UPDATE `spools` SET ${sets} WHERE spoolId=:spoolId";
	// 	return $this->dbo->query($sql);
	// }
	//DELETE
	public function deleteSpool($spoolId){
		$this->dbo->bind("spoolId","$spoolId");
		$sql = "UPDATE `spools` SET deleted=1 WHERE spoolId=:spoolId";
		return $this->dbo->query($sql);
	}
	/* #endregion */

	/* #region	EXTRAS */
	//----------------------------------------------------------------
	//
	//						SPOOL_STAGES
	//
	//----------------------------------------------------------------
	public function createSpoolStage($params){
		extract($params, EXTR_SKIP);
		$bindArray = array(
			"spoolId"    	=>	"$spoolId",
			"processId"    	=>	"$processId",
			"stageTypeId"   =>	"$stageTypeId",
			"locationId"    =>	"$locationId",
			"comment"    	=>	$comment,
			"userId"    	=>	"$userId",
		);
		$this->dbo->bindMore($bindArray);
		$sets = $this->getSetsText($bindArray);
		$sql = "INSERT IGNORE INTO `spool_stages` SET ${sets}";
		$this->dbo->query($sql);
		return $this->dbo->lastInsertId();
	}
	public function createSpoolStageTransaction($params){
		extract($params, EXTR_SKIP);
		$materials = isset($materials) ? $materials : array();
		try {
			$this->dbo->beginTransaction();
			$result = $this->createSpoolStage($params);
			$stageId = $result;
			// if($stageTypeId == ScanIn) {
			// 	$this->lockProcess($processId, $userId);
			// }
			// else {
			// 	$this->unlockProcess($processId);
			// }
			if($stageTypeId == ScanOut) {
				if(count($materials)>0) {
					$this->addMaterialsToStage($stageId, $materials);
					$this->getAndUpdateStageActualMaterials($stageId);
				}
				//update minutes_taken for this newly created scan-out stage
				$stage = $this->getStageById($stageId);
				$scanoutTime = $stage['created_at'];
				$prevScanInStage = $this->getPreviousSpoolScanInStage($spoolId, $stageId, $processId);
				if(!empty($prevScanInStage)) {
					$scaninTime = $prevScanInStage['created_at'];
					$diffInMinutes = $this->datesDifferenceInMinute($scaninTime, $scanoutTime); //find out
					$this->updateStageMinutesTaken($stageId, $diffInMinutes);
				}
				//$this->updateSpoolStatus($spoolId, "Finished");
			}
			if($stageTypeId == ScanIn || $stageTypeId == ScanOut) {
				$joins = $this->getWorkerTeamJoins($userId);
				if($joins != null) {
					$this->giveTeamWorkersCredit($stageId, $joins);
					$this->updateStageTeamCount($stageId, count($joins));
				}
			}
			$this->dbo->executeTransaction();
			return $result;
		}
		catch(Exception $e) {
			$this->dbo->rollBack();
			return false;
		}
	}
	public function canSpoolBeQualityChecked($spoolId){
        $this->dbo->bind("spoolId","$spoolId");
		$sql = "SELECT stageTypeId FROM spool_stages WHERE spoolId=:spoolId ORDER BY stageId DESC";
		$result = $this->dbo->row($sql);
		if(empty($result)) {
			return false;
		}
		else {
			return $result['stageTypeId'] == ScanOut;
		}
		return false;
	}
	public function canSpoolScanIn($spoolId){
        $this->dbo->bind("spoolId","$spoolId");
		$sql = "SELECT stageTypeId FROM spool_stages WHERE spoolId=:spoolId ORDER BY stageId DESC";
		$result = $this->dbo->row($sql);
		if(empty($result)) {
			return true;
		}
		else {
			//allow scanning in if last stage Id is not ScanIN
			return $result['stageTypeId'] != ScanIn;
			//or don't allow scan in at all after first scan in
			//return false;
		}
		return false;
	}
	public function canSpoolScanOut($spoolId){
        $this->dbo->bind("spoolId","$spoolId");
		$sql = "SELECT stageTypeId FROM spool_stages WHERE spoolId=:spoolId ORDER BY stageId DESC";
		$result = $this->dbo->row($sql);
		if(empty($result)) {
			return false;
		}
		else {
			return $result['stageTypeId'] == ScanIn;
		}
		return false;
	}
	/* #endregion */

	/* #region EXTRA VAGANZAA! */
	public function removeMaterialsFromLine($lineId){
		$this->dbo->bind("lineId","$lineId");
		$sql = "DELETE FROM `spool_line_materials` WHERE lineId=:lineId";
		return $this->dbo->query($sql);
	}
    public function addMaterialsToLine($lineId, $materials){
        if(intval($lineId) <= 0){return false;}
        $values = '';
		$length = count($materials);
		$bindArray = array();
        $sql = "INSERT IGNORE INTO `spool_line_materials` (`lineId`, `materialId`, `quantity`) VALUES ";
        for($i=0; $i<$length; $i++){
			$material = 'materialId'.$i; //materialId-1, materialId-2 etc..
			$quantity = 'quantity'.$i; //quantity-1, quantity-2 etc..
			$bindArray[$material] = $materials[$i]['materialId'];
			$bindArray[$quantity] = $materials[$i]['quantity'];
			$values .= "($lineId, :${material}, :${quantity}), ";
		}
		$values = trim($values, ', ');
		$sql .= $values;
		$this->dbo->bindMore($bindArray);
        return $this->dbo->query($sql);
    }
	public function removeMaterialsFromStage($stageId){
		$this->dbo->bind("stageId","$stageId");
		$sql = "DELETE FROM `spool_stage_materials` WHERE stageId=:stageId";
		return $this->dbo->query($sql);
	}

    public function getAndUpdateStageActualMaterials($stageId){
		$materials = $this->getStageActualMaterials($stageId);
		$actualResin = $materials['actualResin'];
		$actualFabric = $materials['actualFabric'];
		return $this->updateStageActualMaterials($stageId, $actualResin, $actualFabric);
    }
    public function getStageActualMaterials($stageId){
		$this->dbo->bindMore(array(
			"stageId" 		=> "$stageId",
		));
		$sql = "SELECT						
				COALESCE(SUM(case when m.materialType = 'Resin' then ssm.quantity else 0 end), 0) as actualResin,
				COALESCE(SUM(case when m.materialType = 'Fabric' then ssm.quantity else 0 end), 0) as actualFabric
				FROM spool_stage_materials as ssm
				INNER JOIN materials as m
				ON ssm.materialId = m.materialId
				WHERE `stageId`=:stageId";
		return $this->dbo->row($sql);
    }
    public function updateStageTeamCount($stageId, $teamCount){
		$this->dbo->bindMore(array(
			"stageId" 		=> "$stageId",
			"teamCount"   => "$teamCount",
		));
		$sql = "UPDATE `spool_stages` SET `teamCount`=:teamCount WHERE `stageId`=:stageId";
		return $this->dbo->query($sql);
    }
    public function updateStageActualMaterials($stageId, $actualResin, $actualFabric){
		$this->dbo->bindMore(array(
			"stageId" 		=> "$stageId",
			"actualResin"   => "$actualResin",
			"actualFabric"  => "$actualFabric",
		));
		$sql = "UPDATE `spool_stages` SET `actualResin`=:actualResin, `actualFabric`=:actualFabric WHERE `stageId`=:stageId";
		return $this->dbo->query($sql);
    }
    public function addMaterialsToStage($stageId, $materials){
        if(intval($stageId) <= 0){return false;}
        $values = '';
		$length = count($materials);
		$bindArray = array();
        $sql = "INSERT IGNORE INTO `spool_stage_materials` (`stageId`, `materialId`, `quantity`) VALUES ";
        for($i=0; $i<$length; $i++){
			$material = 'materialId'.$i; //materialId-1, materialId-2 etc..
			$quantity = 'quantity'.$i; //quantity-1, quantity-2 etc..
			$bindArray[$material] = $materials[$i]['materialId'];
			$bindArray[$quantity] = $materials[$i]['quantity'];
			$values .= "($stageId, :${material}, :${quantity}), ";
		}
		$values = trim($values, ', ');
		$sql .= $values;
		$this->dbo->bindMore($bindArray);
        return $this->dbo->query($sql);
    }
	/* #endregion*/

	/* #region REPORTS */
	public function dailyReport($params){
		$today = date("Y-m-d");
		$filterText = "";
		$filterArray = array('c.customerId', 'o.orderNo', 's.spoolNo');
		$preparedBinds = $this->prepareFilterBinds($filterArray, $params);
		if($preparedBinds) {
			$this->dbo->bindMore($preparedBinds['binds']);
			$filterText = $preparedBinds['texts'];
		}
		//assigned teams don't exist until scanning in and out
		//since orders don't have pre-assigned teams to them
		//same with physical locations
		
		$sql = "SELECT ss.stageId, s.*, concat(IF(stageTypeId=1, 'Under ', 'Finished '), pr.processName) as newStatus, 
				sl.spoolNo, o.orderNo, sl.lineNo, l.locationName, c.customerName, sl.spoolDescription,
				DATE_FORMAT(s.created_at, '$this->dateFormat') as `created_at`,
				GROUP_CONCAT(DISTINCT(u.fullname)) as assignedTeams
				FROM `spools` as s
				INNER JOIN spool_lines as sl
				ON s.lineId = sl.lineId
				INNER JOIN orders as o
				ON o.orderId = sl.orderId
				INNER JOIN projects as p
				ON p.projectId = o.projectId
				INNER JOIN customers as c 
				ON c.customerId = p.customerId
				INNER JOIN 
				(
					SELECT ss.stageId, ss.spoolId, ss.locationId, ss.stageTypeId, ss.userId, ss.teamCount, ss.processId, ss.created_at
					FROM spool_stages as ss
					#https://stackoverflow.com/a/10999689 group by show last row instead of first
					JOIN (SELECT spoolId, MAX(stageId) stageId FROM spool_stages GROUP BY spoolId) ss2
					ON ss.stageId = ss2.stageId AND ss.spoolId = ss2.spoolId  
					GROUP BY ss.spoolId
				) as ss
				ON ss.spoolId = s.spoolId
				INNER JOIN processes as pr
				ON pr.processId = ss.processId
				INNER JOIN locations as l
				ON ss.locationId = l.locationId
				INNER JOIN users as u 
				ON ss.userId = u.userId
				WHERE DATE(ss.created_at) = '$today'
				AND ss.stageTypeId IN (1,2)
				$filterText
				AND s.deleted=0 AND o.deleted=0 AND sl.deleted=0 AND p.deleted=0
				GROUP BY s.spoolId
		ORDER BY ss.stageId DESC";
		return $this->dbo->query($sql);
	}
	public function fabricationsReport($params){
		extract($params, EXTR_SKIP);
		$dateFilter = "";
		if(isset($startDate) && isset($endDate)) {
			$dateFilter = "AND (date(o.created_at) BETWEEN date('$startDate') AND date('$endDate'))";
		}
		$sql = "SELECT c.customerName, p.projectName, o.orderNo, DATE(o.created_at) as created_at,
				COUNT(s.spoolId) orderQuantity, 
				SUM(case when s.status = 'Finished' then 1 else 0 end) as finishedQuantity,
				SUM(case when s.status != 'Finished' then 1 else 0 end) * sl.pricePerPiece as balanceValue, 
				SUM(case when s.status = 'Finished' then 1 else 0 end) * sl.pricePerPiece as finishedValue
				FROM `spools` as s
				INNER JOIN spool_lines as sl
				ON s.lineId = sl.lineId
				INNER JOIN orders as o
				ON o.orderId = sl.orderId
				INNER JOIN projects as p
				ON p.projectId = o.projectId
				INNER JOIN customers as c 
				ON c.customerId = p.customerId
				WHERE s.deleted=0 AND o.deleted=0 AND sl.deleted=0 AND p.deleted=0
				$dateFilter
				GROUP BY o.orderId";
		return $this->dbo->query($sql);
	}
	public function forecastingReport($params){
		extract($params, EXTR_SKIP);
		$dateFilter = "";
		if(isset($startDate) && isset($endDate)) {
			$dateFilter = "AND (date(s.scheduledDeliveryDate) BETWEEN date('$startDate') AND date('$endDate'))";
		}   
		$sql = "SELECT c.customerName, p.projectName, o.orderNo, p.projectName,
				sl.lineNo, sl.spoolDescription, sl.spoolNo, s.serial,
				ROUND((sl.plannedHoursPerPiece * ss.teamCount) - (SUM(ss.minutes_taken * ss.teamCount) / 60), 2) as `balancedHours`,
				sl.pricePerPiece as `value`,
				(sl.plannedHoursPerPiece) as `plannedHours`,
				sl.plannedResinPerPiece as `plannedResin`, 
				sl.plannedFabricPerPiece as `plannedFabric`,
				s.productionOrder,s.scheduledDeliveryDate
				FROM `spools` as s
				INNER JOIN spool_lines as sl
				ON s.lineId = sl.lineId
				INNER JOIN spool_stages as ss
				ON s.spoolId = ss.spoolId
				INNER JOIN orders as o
				ON o.orderId = sl.orderId
				INNER JOIN projects as p
				ON p.projectId = o.projectId
				INNER JOIN customers as c 
				ON c.customerId = p.customerId
				WHERE s.deleted=0 AND o.deleted=0 AND sl.deleted=0 AND p.deleted=0
				$dateFilter
				GROUP BY s.spoolId";
		return $this->dbo->query($sql);
	}
	public function teamPerformanceReport($params){
		extract($params, EXTR_SKIP);
		$bindArray = array();
		$dateFilter = $teamFilter = "";
		if(isset($startDate) && isset($endDate)) {
			$dateFilter = "AND (date(ss.created_at) BETWEEN date('$startDate') AND date('$endDate'))";
		}
		if(isset($userId)) {
			$bindArray['userId'] = $userId;
			$teamFilter = "AND ss.userId = :userId";
		}
		if(count($bindArray) > 0){
			$this->dbo->bindMore($bindArray);
		}
		$sql = "SELECT s.spoolId, c.customerName, p.projectName, o.orderNo, sl.lineNo, sl.spoolNo, s.serial,
				s.productionOrder, DATE_FORMAT(s.created_at, '$this->dateFormat') as `created_at`,
				ROUND(SUM(ss.minutes_taken * ss.teamCount) / 60, 2) as activityHours,
				ROUND(MAX(ss.teamCount) * 9 * ${periodDays}, 2) as paidHours,
				ROUND(SUM(ss.actualResin), 2) as resinConsumption,
				ROUND(SUM(ss.actualFabric), 2) as fabricConsumption
				FROM spool_stages as ss
				INNER JOIN `spools` as s
				ON s.spoolId = ss.spoolId
				INNER JOIN spool_lines as sl
				ON s.lineId = sl.lineId
				INNER JOIN orders as o
				ON o.orderId = sl.orderId
				INNER JOIN projects as p
				ON p.projectId = o.projectId
				INNER JOIN customers as c 
				ON c.customerId = p.customerId
				WHERE s.deleted=0 AND o.deleted=0 AND sl.deleted=0 AND p.deleted=0
				AND ss.stageTypeId IN (1,2)
				$teamFilter
				$dateFilter
				GROUP BY ss.spoolId";
		return $this->dbo->query($sql);
	}
	public function rawMaterialsEfficiencyReport($params){
		extract($params, EXTR_SKIP);
		$dateFilter = "";
		if(isset($startDate) && isset($endDate)) {
			$dateFilter = "AND (date(ss.created_at) BETWEEN date('$startDate') AND date('$endDate'))";
		}
		$sql = "SELECT *,
				CONCAT(ROUND(COALESCE(x.actualResin / x.plannedResin * 100, 0),2), '%') as resinVariance,
				CONCAT(ROUND(COALESCE(x.actualFabric / x.plannedFabric * 100, 0),2), '%') as fabricVariance,
				CONCAT(ROUND(COALESCE(x.actualResin / x.actualFabric * 100, 0),2), '%') as ResinToFabricRatio,
				CONCAT(ROUND(COALESCE(x.actualHours / x.plannedHours * 100, 0),2), '%') as hoursRatio
				FROM (
					SELECT  s.spoolId, sl.spoolNo, o.orderNo, sl.lineNo, c.customerName, p.projectName, s.serial, MAX(ss.teamCount) as teamCount, ss.stageId,
					ROUND(SUM(ss.minutes_taken * ss.teamCount) / 60 , 2) as actualHours,
					ROUND(sl.plannedHoursPerPiece * ss.teamCount, 2) as plannedHours,
					ROUND(COALESCE(SUM(ss.actualResin), 0),2) as actualResin,
					ROUND(COALESCE(SUM(ss.actualFabric), 0),2) as actualFabric,
					ROUND(sl.plannedResinPerPiece, 2) as `plannedResin`, #divide by spoolQuantity => plannedResin for one spool
					ROUND(sl.plannedFabricPerPiece, 2) as `plannedFabric` #same here
					FROM `spools` as s
					INNER JOIN spool_lines as sl
					ON s.lineId = sl.lineId
					INNER JOIN orders as o
					ON o.orderId = sl.orderId
					INNER JOIN projects as p
					ON p.projectId = o.projectId
					INNER JOIN customers as c 
					ON c.customerId = p.customerId
					INNER JOIN `spool_stages` as ss
					ON s.spoolId = ss.spoolId
					WHERE s.deleted=0 AND o.deleted=0 AND sl.deleted=0 AND p.deleted=0
					AND ss.stageTypeId=2
					$dateFilter
					GROUP by s.spoolId
				) as x";
		return $this->dbo->query($sql);
	}
	public function activityReport($params){
		extract($params, EXTR_SKIP);
		$dateFilter = "";
		if(isset($startDate) && isset($endDate)) {
			$dateFilter = "AND (date(ss.created_at) BETWEEN date('$startDate') AND date('$endDate'))";
		}
		//scan in - scan out -> time total of that
		$sql = "SELECT o.orderNo, c.customerName, sl.lineNo, sl.spoolNo, ss.teamCount, p.projectName, s.serial,
				pr.processName, u.userId, u.fullname as teamName, 
				ROUND(SUM(ss.minutes_taken) / 60 * ss.teamCount, 2) as stageHours
				FROM spool_stages as ss
				INNER JOIN spools as s
				ON s.spoolId = ss.spoolId
				INNER JOIN spool_lines as sl
				ON s.lineId = sl.lineId
				INNER JOIN orders as o
				ON o.orderId = sl.orderId
				INNER JOIN projects as p
				ON p.projectId = o.projectId
				INNER JOIN customers as c 
				ON c.customerId = p.customerId
				INNER JOIN processes as pr
				ON pr.processId = ss.processId
				INNER JOIN users as u 
				ON u.userId = ss.userId
				AND u.userType = 'team'
				WHERE s.deleted=0 AND o.deleted=0 AND sl.deleted=0 AND p.deleted=0
				$dateFilter
				GROUP BY ss.spoolId, ss.processId
				ORDER BY ss.stageId DESC";
		return $this->dbo->query($sql);
	}
	// public function ordersDetails($params){
	// 	extract($params, EXTR_SKIP);
	// 	$dateFilter = "";
	// 	if(isset($startDate) && isset($endDate)) {
	// 		$dateFilter = "WHERE (date(ss.created_at) BETWEEN date('$startDate') AND date('$endDate'))";
	// 	}
	// 	$sql = "SELECT x.stageId, x.spoolId, l.locationName, st.stageName, 
	// 			u.fullname, u.userId, u.userType, x.minutes 
	// 			FROM 
	// 			(
	// 				SELECT ss.stageId, ss.spoolId, ss.locationId,
	// 				max(ss.stageTypeId) as lastStage,
	// 				max(ss.userId) as lastUser,
	// 				TIMESTAMPDIFF(MINUTE, MIN(ss.created_at), MAX(ss.created_at)) as minutes
	// 				FROM spool_stages as ss
	// 				GROUP BY ss.spoolId
	// 			) as x
	// 			INNER JOIN stage_types as st
	// 			ON x.lastStage = st.stageTypeId
	// 			INNER JOIN users as u
	// 			ON x.lastUser = u.userId
	// 			INNER JOIN locations as l
	// 			ON l.locationId = x.locationId
	// 			ORDER BY x.spoolId";
	// 	return $this->dbo->query($sql);
	// }
	public function checkOrders() {
		$sql = "SELECT  x.spoolId, x.teamCount, s.serial, sl.spoolNo, o.orderId, o.orderNo,
				c.customerName, p.projectName, p.projectId, c.customerId, x.stageId,
				l.locationName, x.stageTypeId, st.stageName, u.fullname, u.userId, u.userType, x.minutes,
				concat(IF(x.stageTypeId=1, 'Under ', 'Finished '), pr.processName) as `processName` 
				FROM 
				(
					SELECT ss.stageId, ss.spoolId, ss.locationId, ss.stageTypeId, ss.userId, ss.teamCount, ss.processId, ss2.minutes
					FROM spool_stages as ss
					#https://stackoverflow.com/a/10999689 group by show last row instead of first
					JOIN (SELECT spoolId, MAX(stageId) stageId, SUM(minutes_taken * teamCount) as `minutes` FROM spool_stages GROUP BY spoolId) ss2
					ON ss.stageId = ss2.stageId AND ss.spoolId = ss2.spoolId  
					GROUP BY ss.spoolId
				) as x
				INNER JOIN `processes` as pr
				ON x.processId = pr.processId
				INNER JOIN stage_types as st
				ON x.stageTypeId = st.stageTypeId
				INNER JOIN users as u
				ON x.userId = u.userId
				INNER JOIN locations as l
				ON l.locationId = x.locationId
				INNER JOIN spools as s
				ON s.spoolId = x.spoolId
				INNER JOIN spool_lines as sl
				ON sl.lineId = s.lineId
				INNER JOIN orders as o 
				ON o.orderId = sl.orderId
				INNER JOIN `projects` as p
				ON o.projectId = p.projectId
				INNER JOIN `customers` as c
				ON p.customerId = c.customerId
				WHERE s.deleted=0 AND o.deleted=0 AND sl.deleted=0 AND p.deleted=0
				AND x.teamCount != 0  
				ORDER BY `x`.`spoolId`  DESC";
		return $this->dbo->query($sql);
	}
	// public function oldCheckOrders(){
	// 	$sql = "SELECT o.orderId, x.stageId, x.spoolId, l.locationName, x.lastStage, st.stageName, u.fullname, u.userId, u.userType, x.minutes FROM 
	// 			(SELECT ss.stageId, ss.spoolId, ss.locationId,
	// 			max(ss.stageTypeId) as lastStage,
	// 			max(ss.userId) as lastUser,
	// 			TIMESTAMPDIFF(MINUTE, MIN(ss.created_at), MAX(ss.created_at)) as `minutes`
	// 			FROM spool_stages as ss
	// 			GROUP BY ss.spoolId
	// 			) as x
	// 			INNER JOIN stage_types as st
	// 			ON x.lastStage = st.stageTypeId
	// 			INNER JOIN users as u
	// 			ON x.lastUser = u.userId
	// 			INNER JOIN locations as l
	// 			ON l.locationId = x.locationId
	// 			INNER JOIN spools as s
	// 			ON s.spoolId = x.spoolId
	// 			INNER JOIN spool_lines as sl
	// 			ON sl.lineId = s.lineId
	// 			INNER JOIN orders as o 
	// 			ON o.orderId = sl.orderId
	// 			ORDER BY o.orderId DESC, x.spoolId ASC";
	// 	return $this->dbo->query($sql);
	// }
	/* #endregion*/

	/* #region	EXTRAS */
	//----------------------------------------------------------------
	//
	//						EXTRAS
	//
	//----------------------------------------------------------------
	public function getAllDBTablesData(){
		$result=array();
		$tables = $this->dbo->getAllTables();
		foreach($tables as $table) {
			$result[$table] = $this->dbo->getTableData($table);
		}
		return $result;
	}
	public function generateUUID(){
		try {
			$uuid4 = Uuid::uuid4();
			return $uuid4->toString();
		
		} catch (UnsatisfiedDependencyException $e) {
			return false;
		}
	}
	public function haveRequiredFields($requiredfields, $params) {
		$params = array('id'=>1, 'name'=>'ahmed');
		$requiredfields = array('id', 'name');
		$keys = array_keys($params);
		foreach($requiredfields as $r) {
			if(!in_array($r, $keys)) {
				return false;
			};
		}
		return true;
		//return !empty(array_intersect($params, $requiredfields));
	}
	public function getSetsText($binds, $exceptions=array()){
		$sets = "";
		foreach($binds as $key => $value) {
			if(!in_array($key, $exceptions)){
				$sets .= "${key}=:${key}, ";
			}
		}
		return trim($sets, ', ');
	}
	public function prepareFilterBinds($filterArray, $params){
		$binds = array();
		$texts = array();
		foreach($filterArray as $f) {
			$split = explode('.', $f); //c.customerId =>('c', 'customerId')
			$key = $split[1]; //customerId
			if(isset($params[$f])) {
				$value = $params[$f];
				$binds[$f] = "$value";

				$bindText = ":${key}";
				$texts = "AND ${f}=${bindText} "; //AND c.customerId=:customerId
			}
		}
		if(count($binds)>0) {
			return array("binds"=>$binds, "texts"=>$texts);
		}
		return false;
	}
	/* #endregion */
	/* #region	MAINTENANCE */
	//----------------------------------------------------------------
	//
	//						MAINTENANCE
	//
	//----------------------------------------------------------------
	//NOTE THIS IS FOR ONCE IN A LIFE TIME USAGE TO FIX A NEW REQURIEMENT BY THE CLIENT
	//DON'T USE UNLESS YOU ABSOLUTELY KNOW WHAT YOU ARE DOING
	//This for auto generating a new column to help with reports
	//In this case: minutes_taken in spool_stages table
	//This basically solves getting accurate time between stages without Idle time in report queries like (ActivityReport and CheckOrders)
	//Now we can just use sum for all minutes_taken and VOILA!!
    public function updateAllScanOutStagesTransaction() {
		try {
			$this->dbo->beginTransaction();
			$stages = $this->getAllScanoutStages();
			foreach($stages as $s) {
				$scanoutSpoolId = $s['spoolId'];
				$scanoutStageId = $s['stageId'];
				$scanoutProcessId = $s['processId'];
				$scanoutTime = $s['created_at'];

				$prevScanInStage = $this->getPreviousSpoolScanInStage($scanoutSpoolId, $scanoutStageId, $scanoutProcessId);
				if(!empty($prevScanInStage)) {
					$scaninTime = $prevScanInStage['created_at'];
					$diffInMinutes = $this->datesDifferenceInMinute($scaninTime, $scanoutTime); //find out
					$this->updateStageMinutesTaken($scanoutStageId, $diffInMinutes);
				}
			}
			$this->dbo->executeTransaction();
			return true;
		}
		catch(Exception $e) {
			$this->dbo->rollBack();
			return false;
		}
	}
    public function getAllScanoutStages() {
        $sql = "SELECT stageId, processId, spoolId, created_at FROM `spool_stages` WHERE stageTypeId=2";
        return $this->dbo->query($sql);
	}
    public function getPreviousSpoolScanInStage($spoolId, $stageId, $processId) {
        $this->dbo->bindMore(array(
			"spoolId" => "$spoolId",
			"stageId" => "$stageId",
			"processId" => "$processId",
		));
        $sql = "SELECT stageId, created_at FROM `spool_stages`  
				WHERE stageTypeId=1 
				AND stageId < :stageId
				AND processId = :processId
				AND spoolId = :spoolId
				ORDER BY stageId DESC";
        return $this->dbo->row($sql);
	}
    public function updateStageMinutesTaken($stageId, $minutes_taken) {
        $this->dbo->bindMore(array(
            "stageId" 		=> "$stageId",
            "minutes_taken" => "$minutes_taken"
        ));
        $sql = "UPDATE `spool_stages` SET `minutes_taken`=:minutes_taken WHERE `stageId`=:stageId";
        return $this->dbo->query($sql);
	}
	public function datesDifferenceInMinute($date1, $date2) {
		$time = new DateTime($date1);
		$diff = $time->diff(new DateTime($date2));
		$minutes = ($diff->days * 24 * 60) +
				   ($diff->h * 60) + $diff->i;
		return $minutes;
	}

	//To fix a major bug
	public function getAllTimeStages() {
        $sql = "SELECT * FROM `spool_stages`";
        return $this->dbo->query($sql);
	}
	public function getAllWorkerJoinsBeforeStageDate($workerId, $stageDate) {
        $this->dbo->bindMore(array(
			"workerId" => "$workerId",
		));
        $sql = "SELECT * FROM `worker_team` WHERE workerId=:workerId AND DATE(joined_at) <= DATE('$stageDate') ORDER BY joined_at ASC";
        return $this->dbo->query($sql);
	}
	public function getTeamWorkersOfAllTime($userId) {
        $this->dbo->bindMore(array(
			"userId" => "$userId",
		));
        $sql = "SELECT DISTINCT(workerId) FROM `worker_team` WHERE userId=:userId";
        return $this->dbo->query($sql);
	}
	public function isStageWorkerCredited($stageId, $workerId) {
        $this->dbo->bindMore(array(
			"stageId"  => "$stageId",
			"workerId" => "$workerId",
		));
        $sql = "SELECT wc.creditId 
				FROM `worker_team` as wt
				INNER JOIN worker_credits as wc
				ON wt.joinId = wc.joinId
				WHERE wt.workerId=:workerId
				AND wc.stageId=:stageId";
        return !empty($this->dbo->row($sql));
	}
	
	//fix adding actualResin, actualFabric to spool_stage
	//these queries fill them up once, so run this query ONLY IF YOU KNJOW WHAT TO DO 
	public function getAllEmptyStageActualMaterials() {
		$sql = "SELECT * FROM ( SELECT ss.stageId, ss.actualResin, ss.actualFabric,
				ROUND(SUM(case when m.materialType = 'Resin' then ssm.quantity else 0 end),2) as preActualResin,
				ROUND(SUM(case when m.materialType = 'Fabric' then ssm.quantity else 0 end),2) as preActualFabric
				FROM spool_stage_materials as ssm
				INNER JOIN spool_stages as ss
				ON ss.stageId = ssm.stageId
				INNER JOIN materials as m
				ON ssm.materialId = m.materialId
				GROUP BY ss.stageId
			) as x
			WHERE x.preActualResin != x.actualResin
			OR x.preActualFabric != x.actualFabric";
		return $this->dbo->query($sql);
	}
	public function fixAllEmptyStageActualMaterials() {
		$result = $this->getAllEmptyStageActualMaterials();
		if(!empty($result)) {
			$stages = array_column($result, 'stageId');
			foreach($stages as $s) {
				$this->getAndUpdateStageActualMaterials($s);
			}
		}
	}
	//fix adding teamCount to spool_stage
	public function getAllEmptyStageTeamCount() {
		$sql = "SELECT 
				wc.teamCount as preTeamCount, 
				ss.* 
				FROM spool_stages as ss
				INNER JOIN (
					SELECT wc.stageId, COUNT(wc.joinId) as `teamCount` 
					FROM worker_credits as wc
					INNER JOIN worker_team as wt
					ON wt.joinId = wc.joinId
					INNER JOIN workers as w
					ON wt.workerId = w.workerId
					WHERE w.deleted = 0
					GROUP BY wc.stageId
				) as wc
				ON ss.stageId = wc.stageId
				WHERE wc.teamCount != 0
				AND wc.teamCount IS NOT NULL  
				ORDER BY `wc`.`teamCount` DESC";
		return $this->dbo->query($sql);
	}
	public function fixAllEmptyStageTeamCount() {
		$result = $this->getAllEmptyStageTeamCount();
		if(!empty($result)) {
			foreach($result as $s) {
				$stageId = $s['stageId'];
				$teamCount = $s['preTeamCount'];
				$this->updateStageTeamCount($stageId, $teamCount);
			}
		}
	}
	/* #endregion */
}
?>
