<?php
use Slim\Http\Request;
use Slim\Http\Response;
use Endroid\QrCode\QrCode;

// Routes
$app->post('/auth/login', function ($request, $response, $args) {
	$result = $this->controller->login($request->getParsedBody(), $this->_platform);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/auth/forgot', function ($request, $response, $args) {
	$result = $this->controller->forgotPassword($request->getParsedBody(), $this->_platform);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/auth/reset', function ($request, $response, $args) {
    $result = $this->controller->resetUserPassword($request->getParsedBody(), $this->_platform);
	return $response->withJson($result, $response->getStatusCode());
}); 
$app->get('/auth/role', function ($request, $response, $args) {
    $result = $this->model->getUserGroupById($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/auth/user', function ($request, $response, $args) {
    $result = $this->model->getUserOrTeamById($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});  
$app->post('/logout-mobile', function ($request, $response, $args) {
    $result = $this->controller->createMobileActivity('auth', 'logout', 0, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
/* currently not needed
$app->get('/authorize/{state}', function ($request, $response, $args) {
    extract($args, EXTR_SKIP);
    $state = isset($state) ? $state : '';
    $result = $this->controller->authorizeState($this->_userId, $state);
	return $response->withJson($result, $response->getStatusCode());
});
*/
$app->post('/refreshUser', function ($request, $response, $args) {
    $result = $this->model->getUserById($this->_userId);
    $result['permissions'] = array_column($this->model->getUserPermissionKeywords($this->_userId), 'keyword');
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/customers/all', function ($request, $response, $args) {
    $result = $this->controller->getAllCustomers($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/customers/one/{id}', function ($request, $response, $args) {
    $result = $this->controller->getCustomerById($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/customers/new', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->createCustomer($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/customers/edit', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->updateCustomer($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/customers/delete', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->deleteCustomer($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/centers/all', function ($request, $response, $args) {
    $result = $this->controller->getAllCenters($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/centers/one/{id}', function ($request, $response, $args) {
    $result = $this->controller->getCenterById($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/centers/new', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->createCenter($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/centers/edit', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->updateCenter($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/centers/delete', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->deleteCenter($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/stations/all', function ($request, $response, $args) {
    $result = $this->controller->getAllStations($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/stations/all-grouped', function ($request, $response, $args) {
	$result = $this->controller->getAllStations($this->_userId);
	if(!isset($result['error'])) {
		$result = array_group_by($result, 'centerName');
	}
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/stations/one/{id}', function ($request, $response, $args) {
    $result = $this->controller->getStationById($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/stations/new', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->createStation($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/stations/edit', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->updateStation($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/stations/delete', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->deleteStation($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/users/all', function ($request, $response, $args) {
    $result = $this->controller->getAllUsers($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/users/one/{id}', function ($request, $response, $args) {
    $result = $this->controller->getUserById($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/users/stations/{id}', function ($request, $response, $args) {
    $result = $this->controller->getUserStations($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/users/new', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->createUser($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/users/edit', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->updateUser($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/users/delete', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->deleteUser($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/user_groups/all', function ($request, $response, $args) {
    $result = $this->controller->getUserGroups($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});


$app->get('/materials/all', function ($request, $response, $args) {
    $result = $this->controller->getAllMaterials($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/materials/all-grouped', function ($request, $response, $args) {
	$result = $this->controller->getAllMaterials($this->_userId);
	if(!isset($result['error'])) {
		$result = array_group_by($result, 'materialType');
	}
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/materials/one/{id}', function ($request, $response, $args) {
    $result = $this->controller->getMaterialById($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/materials/new', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->createMaterial($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/materials/edit', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->updateMaterial($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/materials/delete', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->deleteMaterial($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/workers/all', function ($request, $response, $args) {
    $result = $this->controller->getAllWorkers($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/workers/one/{id}', function ($request, $response, $args) {
    $result = $this->controller->getWorkerById($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/workers/new', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->createWorker($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/workers/edit', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->updateWorker($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/workers/delete', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->deleteWorker($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/processes/all', function ($request, $response, $args) {
    $result = $this->controller->getAllProcesses($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/processes/one/{id}', function ($request, $response, $args) {
    $result = $this->controller->getProcessById($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/processes/new', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->createProcess($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/processes/edit', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->updateProcess($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/processes/delete', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->deleteProcess($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/teams/all', function ($request, $response, $args) {
    $result = $this->controller->getAllTeams($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/teams/all/visible', function ($request, $response, $args) {
    $result = $this->controller->getAllVisibleTeams($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/teams/one/{id}', function ($request, $response, $args) {
    $result = $this->controller->getTeamById($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/teams/workers/{id}', function ($request, $response, $args) {
    $result = $this->controller->getTeamWorkers($args);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/teams/new', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->createTeam($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/teams/edit', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->updateTeam($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/teams/delete', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->deleteTeam($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/projects/all', function ($request, $response, $args) {
    $result = $this->controller->getAllProjects($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/projects/one/{id}', function ($request, $response, $args) {
    $result = $this->controller->getProjectById($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/projects/new', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->createProject($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/projects/edit', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->updateProject($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/projects/delete', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->deleteProject($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/orders/all', function ($request, $response, $args) {
    $result = $this->controller->getAllOrders($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/orders/one/{id}', function ($request, $response, $args) {
    $result = $this->controller->getOrderById($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/orders/new', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->createOrder($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/orders/edit', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->updateOrder($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/orders/delete', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->deleteOrder($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/lines/all', function ($request, $response, $args) {
    $result = $this->controller->getAllLines($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/lines/one/{id}', function ($request, $response, $args) {
    $result = $this->controller->getLineById($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/lines/new', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->createLine($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/lines/edit', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->updateLine($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/lines/delete', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->deleteLine($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/spools/all', function ($request, $response, $args) {
    $result = $this->controller->getAllSpools($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/spools/one/{id}', function ($request, $response, $args) {
    $result = $this->controller->getSpoolById($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/spools/last-stage/{id}', function ($request, $response, $args) {
    $result = $this->controller->getSpoolLastStageById($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->get('/spools/scan/{uuid}', function ($request, $response, $args) {
    $result = $this->controller->getSpoolByUUID($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/spools/edit', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->updateSpool($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/spools/stages/new', function ($request, $response, $args) {
	$params = $request->getParsedBody();
	$result = $this->controller->createSpoolStage($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/spools/status', function ($request, $response, $args) {
	$params = $request->getParsedBody();
	$result = $this->controller->updateSpoolStatus($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/spoolTypes/all', function ($request, $response, $args) {
    $result = $this->controller->getAllSpooltypes($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/spoolTypes/new', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->createSpooltype($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/spoolTypes/edit', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->updateSpooltype($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/spoolTypes/delete', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->deleteSpooltype($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/locations/all', function ($request, $response, $args) {
    $result = $this->controller->getAllLocations($this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/locations/new', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->createLocation($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/locations/edit', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->updateLocation($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/locations/delete', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->deleteLocation($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/check-orders/grouped', function ($request, $response, $args) {
	// $params = $request->getParsedBody();
	$result = $this->controller->checkOrders($this->_userId);
	if(!isset($result['error'])) {
		$result = array_group_by($result, 'orderId');
	}
	return $response->withJson($result, $response->getStatusCode());
});

$app->post('/reports/daily', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->dailyReport($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->post('/reports/fabrications', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->fabricationsReport($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->post('/reports/forecasting', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->forecastingReport($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/reports/team-performance', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->teamPerformanceReport($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/reports/materials-efficiency', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->rawMaterialsEfficiencyReport($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});
$app->post('/reports/activity', function ($request, $response, $args) {
	$params = $request->getParsedBody();
    $result = $this->controller->activityReport($params, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/excel/all', function ($request, $response, $args) {
	$data = $this->model->getAllDBTablesData();
	$filename = $this->lib->tablesToExcelFile($data);
	$file = file_get_contents($filename);
	$response->write($file);
	$response = $response->withHeader('Content-Disposition', 'attachment; filename="all.xlsx"');
	return $response->withHeader('Content-Type', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
});

//can be used for serving qrcode images
// $app->get('/qrcode/{uuid}', function ($request, $response, $args) {
// 	$uuid = $args['uuid'];
//     $result = $this->controller->serveQrcode($uuid);
// 	return $response->withJson($result, $response->getStatusCode());
// });

//can be used for serving qrcode images
$app->get('/get/{id}', function ($request, $response, $args) {
    $result = $this->controller->getOrderById($args, $this->_userId);
	return $response->withJson($result, $response->getStatusCode());
});

$app->get('/qrcode/{uuid}', function ($request, $response, $args) {
	$uuid = $args['uuid'];
	if(empty($uuid)){return false;}
	$data = $this->model->getSpoolByUUID($uuid);
	if(empty($data)){return false;}
	$qrCode = new QrCode($uuid);
	$qrCode->setSize(__QRCODE_SIZE__);
	$qrCode->setMargin(__QRCODE_MARGIN__);
	$qrCode->setEncoding('UTF-8');
	$image = $qrCode->writeString();
	$response->write($image);
	return $response->withHeader('Content-Type', $qrCode->getContentType());
});

//can be used for serving qrcode images
$app->get('/test', function ($request, $response, $args) {
	$qrCode = new QrCode('Life is too short to be generating QR codes');
	$qrCode->setSize(__QRCODE_SIZE__);
	$qrCode->setMargin(__QRCODE_MARGIN__);
	$qrCode->setEncoding('UTF-8');
	$image = $qrCode->writeString();
	$response->write($image);
	return $response->withHeader('Content-Type', $qrCode->getContentType());
});

//can be used to generate qrcodes
$app->get('/generate-qrcode', function ($request, $response, $args) {
	$result = true;
	$qrCode = new QrCode('Life is too short to be generating QR codes');
	$qrCode->setSize(__QRCODE_SIZE__);
	$qrCode->setMargin(__QRCODE_MARGIN__);
	$qrCode->setEncoding('UTF-8');
	$qrCode->writeFile(__QRCODES_ROOT__.'qrcode.png');
	return $response->withJson($result, $response->getStatusCode());
});