<?php
require_once('../php/settings.php');
require_once('../php/classes/lib/lib.php');
require_once('../php/classes/JWT/JWT.php');
require_once('../php/custom/group_by.php');
require_once('../php/classes/DB/DB.php');
require_once('../php/classes/model/model.php');
require_once('../php/classes/controller/controller.php');
require_once('../php/pusher/pusher.php');
require_once('../php/phpMailer/function.phpmailer.php');
require_once('../php/sms/sms.php');

// DIC configuration
$container = $app->getContainer();
// view renderer
$container['renderer'] = function ($c) {
    $settings = $c->get('settings')['renderer'];
    return new Slim\Views\PhpRenderer($settings['template_path']);
};

// monolog
$container['logger'] = function ($c) {
    $settings = $c->get('settings')['logger'];
    $logger = new Monolog\Logger($settings['name']);
    $logger->pushProcessor(new Monolog\Processor\UidProcessor());
    $logger->pushHandler(new Monolog\Handler\StreamHandler($settings['path'], $settings['level']));
    return $logger;
};

$container["db"] = function ($container) {
    return new DB(DB_HOST,DB_NAME, DB_USER, DB_PASS);
};

$container["lib"] = function ($container) {
    return new lib();
};

$container["model"] = function ($container) {
	$db = new DB(DB_HOST,DB_NAME, DB_USER, DB_PASS);
    return new model($db);
};
$container["controller"] = function ($container) {
	$db = new DB(DB_HOST,DB_NAME, DB_USER, DB_PASS);
    return new controller(new model($db), new lib());
};
$container["_userId"] = function ($container) {
    return new Int();
};
$container["_platform"] = function ($container) {
    return new String();
};
$container["_version"] = function ($container) {
    return new String();
};
