<?php
// Application middleware
$app->add(function ($request, $response, $next) use ($container) {
	$uri=$request->getUri();
	$path=$uri->getPath();
	if(substr($path, 0, strlen('qrcode')) === 'qrcode') {
		$response = $next($request, $response);
		return $response;
	}
	if($request->getMethod() != 'OPTIONS') {
		$errorMessage = array("error" => "Invalid request");
		$allowedAppNames = array('Amiantit-Mobile', 'Amiantit-Web');
		$appNameheader = $request->getHeader('AppName');
		$appName = !empty($appNameheader) ? $appNameheader[0] : '';
		if($appName == '' || !in_array($appName, $allowedAppNames)) {
			return $response->withJson($errorMessage, $response->getStatusCode());
		}
		else {
			if($appName == 'Amiantit-Mobile') {
				$platform = "mobile";
			}
			else if($appName == 'Amiantit-Web') {
				$platform = "web";
			}
			$container["_platform"] = $platform;
		}
		$versionHeader = $request->getHeader('AppVersion');
		$version = !empty($versionHeader) ? $versionHeader[0] : '';
		if($version != '') {
			$container["_version"] = $version;
		}
		else {
			return $response->withJson($errorMessage, $response->getStatusCode());
		}
	}
    $response = $next($request, $response);
    return $response;
});
$app->add(new \Slim\Middleware\JwtAuthentication([
    "secret" => AUTH_SECRET,
	"path" => "/",
    "passthrough" => ["/auth/login", "/auth/reset", "/auth/forgot", "/qrcode/*", "/generate-qrcode", "/get/*"],
    "header" => "Auth-Token",
    "callback" => function ($request, $response, $arguments) use ($container) {
        $db = new DB(DB_HOST,DB_NAME, DB_USER, DB_PASS);
		$model = new model($db);
		
        $decoded = (array)$arguments["decoded"];
        $userId = $decoded['userId'];
        $isValid = $model->isUserExistAndActive($userId);
        if($isValid) {
            $container["_userId"] = $userId;
        }
        else {
            return false;
        }
    },
    "secure" => false,
    "error" => function ($request, $response, $arguments) {
        $data["status"] = "error";
        //$data["message"] = $arguments["message"];
        $data["message"] = 'Unauthorized';
        return $response
            ->withHeader("Content-Type", "application/json")
            ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
    }
]));

$app->add(function ($req, $res, $next) {
    $response = $next($req, $res);
    return $response
        ->withHeader('Access-Control-Allow-Origin', '*')
        ->withHeader('Access-Control-Allow-Headers', 'X-Requested-With, Content-Type, Accept, Origin, Authorization, AppVersion, AppName, Auth-Token')
        ->withHeader('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, PATCH, OPTIONS');
});